/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla.renderer;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueTextItem;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class TicketIdItem
extends IssueTextItem {
    private static final long serialVersionUID = 1L;
    @Alias(name="asLink")
    private boolean asLink = true;

    public TicketIdItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        DataRow row = context.getDataRow();
        String issueKey = row.getValueAsString("issueKey");
        String issueUrl = (String)context.get("ISSUE_URL");
        if (StringUtils.isEmpty((String)issueUrl)) {
            issueUrl = issueKey;
        } else {
            issueUrl = issueUrl.replace("$KEY", issueKey);
            StringBuffer sb = new StringBuffer();
            String status = row.getValueAsString("status").toLowerCase();
            String text = this.getText(context);
            String css = this.getCss();
            if (css == null) {
                css = "";
            }
            if (this.isAsLink()) {
                sb.append("<a class=\"issue-link issue-status ").append(status).append(" " + css).append("\" href=\"").append(issueUrl).append("\">").append(text).append("</a>");
            } else {
                sb.append("<span class=\"issue-status ").append(status).append(" " + css).append("\">").append(text).append("</span>");
            }
            issueUrl = sb.toString();
        }
        return new Label(id, issueUrl).setEscapeModelStrings(false);
    }

    public boolean isAsLink() {
        return this.asLink;
    }

    public void setAsLink(boolean asLink) {
        this.asLink = asLink;
    }
}

