/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportGadgetWithTable;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.tracker.bugzilla.BugzillaPlugin;
import com.pmease.quickbuild.plugin.tracker.bugzilla.gadget.BugzillaGadgetRenderer;
import com.pmease.quickbuild.plugin.tracker.bugzilla.setting.BugzillaSetting;
import com.pmease.quickbuild.plugin.tracker.core.gadget.AbstractIssueGadget;
import java.util.List;

@Editable(name="Bugzilla Issues", category={"Changes and Issues"})
public class BugzillaGadget
extends AbstractIssueGadget {
    private static final long serialVersionUID = 1L;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(BugzillaPlugin.class);
    }

    protected void checkPermission() {
        super.checkPermission();
        if (BugzillaSetting.get(Context.getConfiguration()) == null) {
            throw new QuickbuildException("No Bugzilla setting defined for the configuration: " + Context.getConfiguration().getPathName());
        }
    }

    protected TableRenderer createGadgetRenderer() {
        return new BugzillaGadgetRenderer(this.getCategory(), (ReportGadgetWithTable)this);
    }

    private static List<String> getAvailableColumns() {
        return Lists.newArrayList((Object[])new String[]{"Key", "Summary", "Severity", "Status", "Priority", "Resolution", "Owner", "Modifications"});
    }
}

