/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla.client;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.tracker.bugzilla.client.BugzillaIssue;
import com.pmease.quickbuild.plugin.tracker.bugzilla.setting.BugzillaSetting;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugzillaClient {
    private static final Logger logger = LoggerFactory.getLogger(BugzillaClient.class);
    private final BugzillaSetting server;
    private XmlRpcClient client;
    private HttpClient httpClient;
    private static final String[] REQUIRED = new String[]{"product", "component", "summary", "version", "op_sys", "platform", "priority", "severity"};

    public BugzillaClient(BugzillaSetting server) {
        this.server = server;
        if (logger.isDebugEnabled()) {
            logger.debug("Initial RPC Client ...");
        }
        this.client = new XmlRpcClient();
        XmlRpcCommonsTransportFactory factory = new XmlRpcCommonsTransportFactory(this.client);
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            this.httpClient = new HttpClient();
            factory.setHttpClient(this.httpClient);
            this.client.setTransportFactory((XmlRpcTransportFactory)factory);
            config.setServerURL(new URL(this.getRpcUrl()));
            this.client.setConfig((XmlRpcClientConfig)config);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public BugzillaClient(String host, String user, String password) {
        this(new BugzillaSetting(host, user, password));
    }

    public static BugzillaClient newInstance() {
        BugzillaSetting setting = BugzillaSetting.get(Context.getConfiguration());
        if (setting == null) {
            throw new IllegalArgumentException("Bugzilla setting should be defined first!");
        }
        return new BugzillaClient(setting);
    }

    protected String getRpcUrl() {
        return StringHelper.normalizeUrl((String)this.server.getHost()) + "/xmlrpc.cgi";
    }

    public Object execute(String method, Object ... args) {
        try {
            return this.client.execute(method, args);
        }
        catch (XmlRpcException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public String login() {
        if (logger.isDebugEnabled()) {
            logger.debug("Login to server " + (Object)((Object)this.server));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("login", this.server.getUser());
        map.put("password", this.server.getPassword());
        map.put("rememberlogin", "Bugzilla_remember");
        Object obj = this.execute("User.login", map);
        return (String)((Map)obj).get("token");
    }

    public Integer createIssue(Map<String, String> params) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating bug: " + params.get("summary"));
        }
        params.put("Bugzilla_login", this.server.getUser());
        params.put("Bugzilla_password", this.server.getPassword());
        Map result = (Map)this.execute("Bug.create", params);
        Object[] missed = this.checkParams(params);
        if (missed.length > 0) {
            throw new IllegalArgumentException("Below attributes are required: " + StringUtils.join((Object[])missed, (String)", "));
        }
        return (Integer)result.get("id");
    }

    protected String[] checkParams(Map<String, String> params) {
        ArrayList<String> missed = new ArrayList<String>();
        for (String each : REQUIRED) {
            if (!StringUtils.isEmpty((String)params.get(each))) continue;
            missed.add(each);
        }
        return missed.toArray(new String[missed.size()]);
    }

    public Map<String, Issue> getIssues(String[] ids) {
        Object[] bugs;
        if (logger.isDebugEnabled()) {
            logger.debug("Retriving bugs: " + StringUtils.join((Object[])ids, (String)", "));
        }
        if (ids == null || ids.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("permissive", true);
        map.put("ids", ids);
        map.put("Bugzilla_login", this.server.getUser());
        map.put("Bugzilla_password", this.server.getPassword());
        HashMap<String, Issue> issues = new HashMap<String, Issue>();
        Map result = (Map)this.execute("Bug.get_bugs", map);
        for (Object each : bugs = (Object[])result.get("bugs")) {
            if (each == null || !(each instanceof Map)) continue;
            BugzillaIssue issue = new BugzillaIssue((Map)each);
            issues.put(issue.getIssueKey(), issue);
        }
        return issues;
    }

    public Issue getIssue(String issueKey) {
        Map<String, Issue> result = this.getIssues(new String[]{issueKey});
        return result.get(issueKey);
    }

    public BugzillaSetting getServer() {
        return this.server;
    }

    public static enum Action {
        CREATEISSUE;

    }
}

