/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.tracker.bugzilla.BugzillaPlugin;
import com.pmease.quickbuild.plugin.tracker.bugzilla.client.BugzillaClient;
import com.pmease.quickbuild.plugin.tracker.bugzilla.setting.BugzillaSetting;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class BugzillaTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;

    public String getIssueUrlPattern() {
        BugzillaSetting setting = BugzillaSetting.get(Context.getConfiguration());
        return StringHelper.normalizeUrl((String)setting.getHost()) + "/show_bug.cgi?id=$KEY";
    }

    public String extractIssueKey(String matched) {
        Long id = TrackerHelper.extractLong((String)matched);
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        return BugzillaPlugin.class;
    }

    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        BugzillaClient client = BugzillaClient.newInstance();
        client.login();
        return client.getIssues(keys.toArray(new String[keys.size()]));
    }
}

