/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats.web;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.buildstats.web.BuildStatsHeaderPanel;
import com.pmease.quickbuild.plugin.report.buildstats.web.StepStatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StepsStatsPanel
extends StatisticsPanel {
    private static final long serialVersionUID = 1L;
    static final List<CompareOption> COMPARE_OPTIONS = ImmutableList.of((Object)CompareOption.ONE_METRIC, (Object)CompareOption.OTHER_METRICS);

    public StepsStatsPanel(String id, StatisticsRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    public String getTitle() {
        return this.renderer.getTabName() + " <span class='light-text'>(" + ReportUtils.cropText((String)this.getPrimaryItem().getTitle(), (int)48, (int)1) + ")</span>";
    }

    protected DataReport loadReport(Long configId, StatisticsItem item, Builds builds) {
        DataReport report = super.loadReport(configId, item, builds);
        for (DataRow each : report.getRows()) {
            String status = each.getValueAsString("status");
            StepRuntime.Status stepStatus = StepRuntime.Status.SUCCESSFUL;
            if (!Strings.isNullOrEmpty((String)status)) {
                stepStatus = StepRuntime.Status.valueOf((String)status.toUpperCase());
            }
            each.setValue("successed", (Object)(stepStatus == StepRuntime.Status.SUCCESSFUL ? 1 : 0));
        }
        return report;
    }

    protected List<Filter> getFilters(StatisticsItem item) {
        return Lists.newArrayList((Object[])new Filter[]{Restrictions.eq((String)"stepPath", (Object)((StepStatisticsItem)item).getStepPath())});
    }

    public List<CompareOption> getCompareOptions() {
        return COMPARE_OPTIONS;
    }

    public String getCompareOptionLabel(CompareOption option) {
        switch (option) {
            case ONE_METRIC: {
                return "Current Step";
            }
            case OTHER_METRICS: {
                return "Compare to other steps";
            }
        }
        throw new IllegalArgumentException("The option is not supported!");
    }

    protected Component createStatsHeader(String id) {
        BuildStatsHeaderPanel header = new BuildStatsHeaderPanel(id, this);
        header.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"no-reportset")))});
        return header;
    }
}

