/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats.web;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.buildstats.StepsStatisticsRenderer;
import com.pmease.quickbuild.plugin.report.buildstats.web.StepStatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.ReportTab;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import java.util.ArrayList;
import java.util.List;

public class StepReportTab
extends ReportTab {
    private static final long serialVersionUID = 1L;

    public StepReportTab(StepsStatisticsRenderer renderer) {
        super((AbstractRenderer)renderer);
    }

    protected void resetSessionData(RendererContext context) {
        String newCategoryId;
        SessionData data = SessionData.get();
        Long currentConfiguration = Context.getConfiguration().getId();
        String oldCategoryId = data.getCategoryId();
        if (!Objects.equal((Object)oldCategoryId, (Object)(newCategoryId = this.renderer.getCategory().getId()))) {
            LineChartOption option = new LineChartOption();
            data.setLineChartOption(option);
        } else {
            LineChartOption option = data.getLineChartOption();
            StepsStatisticsRenderer renderer = (StepsStatisticsRenderer)this.renderer;
            List<StatisticsItem> available = renderer.getItems();
            StatisticsItem primary = option.getPrimaryItem();
            if (primary != null && primary instanceof StepStatisticsItem && (primary = this.getItem(((StepStatisticsItem)primary).getStepPath())) == null) {
                primary = available.get(0);
            }
            option.setPrimaryItem(primary);
            List comparisons = option.getComparisonItems();
            ArrayList actual = Lists.newArrayList();
            for (StatisticsItem each : comparisons) {
                StatisticsItem item;
                if (!(each instanceof StepStatisticsItem) || (item = this.getItem(((StepStatisticsItem)each).getStepPath())) == null) continue;
                actual.add(item);
            }
            option.setComparisonItems((List)actual);
        }
        data.setCategoryId(this.renderer.getCategory().getId());
        data.setConfigurationId(currentConfiguration);
        data.setReportSet("DEFAULT");
    }

    private StatisticsItem getItem(String stepPath) {
        List<StatisticsItem> items = ((StepsStatisticsRenderer)this.renderer).getItems();
        for (StatisticsItem each : items) {
            StepStatisticsItem item = (StepStatisticsItem)each;
            if (!Objects.equal((Object)item.getStepPath(), (Object)stepPath)) continue;
            return each;
        }
        return null;
    }
}

