/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats.web;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.buildstats.web.BuildStatsHeaderPanel;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BuildStatsPanel
extends StatisticsPanel {
    private static final long serialVersionUID = 1L;

    public BuildStatsPanel(String id, StatisticsRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected DataReport loadReport(Long configId, StatisticsItem item, Builds builds) {
        DataReport report = this.renderer.getCategory().createReport("buildstats");
        for (BuildFragment each : builds) {
            DataRow row = report.addRow();
            row.setValue("buildId", (Object)each.getId());
            row.setValue("duration", (Object)each.getDuration());
            row.setValue("status", (Object)(each.getStatus() == Build.Status.SUCCESSFUL || each.getStatus() == Build.Status.RECOMMENDED ? 1 : 0));
        }
        return report;
    }

    public boolean hasExcludingFailed() {
        return !this.getChartOption().getPrimaryItem().getValueExpression().equalsIgnoreCase("status") || this.getChartOption().getCompareOption() == CompareOption.OTHER_METRICS;
    }

    protected Component createStatsHeader(String id) {
        BuildStatsHeaderPanel header = new BuildStatsHeaderPanel(id, this);
        header.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"no-reportset")))});
        return header;
    }
}

