/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats.migration;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public class BuildStatsMigrator
extends ReportCategoryMigrator {
    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        this.migrateFromXMLToH2(context);
    }

    protected void stats3To4(MigrationContext context, CategoryDb db) {
        File reportDir = db.getDbDir();
        ReportCategory category = db.getCategory();
        Collection files = FileUtils.listFiles((File)reportDir, (String)"**/stepstats.xml");
        ReportMetaData meta = category.getMeta("stepstats");
        HashSet keys = Sets.newHashSet();
        for (File file : files) {
            DataReport report = new DataReport(meta);
            report.loadFromXML(file);
            for (DataRow each : report.getRows()) {
                String key = each.getRowKeyString();
                if (keys.contains(key)) {
                    SqlBuilder sql = SqlBuilder.deleteFrom((String)"stepstats").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)each.getLong("buildId")), Restrictions.eq((String)"stepPath", (Object)each.getString("stepPath"))});
                    db.update(sql);
                }
                db.persistRow(each);
                keys.add(key);
            }
        }
    }
}

