/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.buildstats.BuildStatsPlugin;
import com.pmease.quickbuild.plugin.report.buildstats.gadget.BuildStatsGadgetRenderer;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.LineChartGadget;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Build Stats", category={"Configuration and Build"})
public class BuildStatsGadget
extends LineChartGadget {
    private static final long serialVersionUID = 1L;

    protected StatisticsRenderer createRenderer() {
        return new BuildStatsGadgetRenderer(ReportHelper.getCategory(BuildStatsPlugin.class));
    }

    protected void checkPermission() {
        if (!SecurityHelper.hasPermission((String)ConfigurationPermission.ACCESS_STATISTICS.name())) {
            throw new AccessDeniedException("You have no permission to access report " + this.getRenderer().getCategory().getName());
        }
    }

    @Editable(name="Indicators", order=400)
    @ChoiceProvider(value="getAvailableIndicators")
    @Size(min=1)
    public List<String> getIndicators() {
        return super.getIndicators();
    }

    public List<String> getReportsets() {
        return new ArrayList<String>();
    }

    private static List<String> getAvailableIndicators() {
        return Lists.newArrayList((Object[])new String[]{"Duration", "Success Rate"});
    }
}

