/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats;

import com.pmease.quickbuild.plugin.report.buildstats.StepHelper;
import com.pmease.quickbuild.plugin.report.buildstats.web.StepReportTab;
import com.pmease.quickbuild.plugin.report.buildstats.web.StepStatisticsItem;
import com.pmease.quickbuild.plugin.report.buildstats.web.StepsStatsPanel;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class StepsStatisticsRenderer
extends StatisticsRenderer {
    private static final long serialVersionUID = 1L;
    @Alias(name="item")
    private String itemName;

    public StepsStatisticsRenderer(ReportCategory category) {
        super(category);
    }

    public boolean isApplicable() {
        return super.isApplicable();
    }

    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
    }

    public Panel createReportPanel(String panelId, IModel<RendererContext> contextModel) {
        return new StepsStatsPanel(panelId, this, contextModel);
    }

    public List<Tab> getContributeTabs() {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        Collection<String> names = StepHelper.getStepNames();
        if (names.size() > 0) {
            tabs.add((Tab)new StepReportTab(this));
        }
        return tabs;
    }

    public List<StatisticsItem> getItems() {
        ArrayList<StatisticsItem> items = new ArrayList<StatisticsItem>();
        Collection<String> names = StepHelper.getStepNames();
        for (String name : names) {
            StepStatisticsItem item = new StepStatisticsItem(this.category, name);
            item.setTitle(name);
            item.setTabName(name);
            item.setReportName("stepstats");
            item.setValueExpression(this.itemName);
            if ("duration".equalsIgnoreCase(this.itemName)) {
                item.setDataType(DataTypes.DURATION);
            } else {
                item.setDataType(DataTypes.BOOLEAN);
            }
            items.add(item);
        }
        return items;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }
}

