/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.buildstats;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.generator.statistics.StatisticsGenerator;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.LastBuildsFile;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StepStatisticsGenerator
extends StatisticsGenerator {
    private static final long serialVersionUID = 1L;

    public StepStatisticsGenerator(ReportCategory category) {
        super(category);
        this.setDestReportName("stepstats");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        Build build = this.getContext().getCurrentBuild();
        File workingDir = this.getContext().getReportCategory().getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        CategoryDb db = this.getContext().getReportCategory().getCategoryDb(workingDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "StepStatisticsGenerator::generate");
            LastBuildsFile lbf = new LastBuildsFile(workingDir);
            lbf.load();
            List ids = lbf.getBuildIds();
            if (ids.size() > 0) {
                Collections.sort(ids);
                Collections.reverse(ids);
                ids = ReportUtils.limitListSize((List)ids, (int)50, (boolean)true);
                long fromId = (Long)Iterables.getLast((Iterable)ids, (Object)Long.MAX_VALUE);
                long toId = (Long)Iterables.getFirst((Iterable)ids, (Object)Long.MAX_VALUE);
                Preconditions.checkState((fromId <= toId ? 1 : 0) != 0);
                HashSet availables = Sets.newHashSet((Iterable)BuildUtils.findBuildIds((Long)build.getConfiguration().getId(), (Long)fromId, (Long)toId, (int)50));
                if (Context.getLogger().isDebugEnabled()) {
                    Context.getLogger().debug("Removing previous builds which were deleted, availables: [" + Joiner.on((String)",").join((Iterable)availables) + "], latest ids: [" + Joiner.on((String)",").join((Iterable)ids) + "]");
                }
                boolean hasRemoved = false;
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    Long id = (Long)it.next();
                    if (availables.contains(id)) continue;
                    Context.getLogger().info("Deleting step records of build " + id);
                    db.update("DELETE FROM stepstats WHERE buildId=" + id);
                    it.remove();
                    hasRemoved = true;
                }
                if (hasRemoved) {
                    lbf.setBuildIds(ids);
                    lbf.save();
                }
            }
            Context.getLogger().info("Deleting step records of current build " + build.getId());
            db.update("DELETE FROM stepstats WHERE buildId=" + build.getId());
            DataReport destReport = this.getCategory().createReport(this.getDestReportName());
            for (Step step : build.getSteps()) {
                DataRow row = destReport.addRow();
                row.setValue("buildId", (Object)build.getId());
                row.setValue("stepPath", (Object)step.getPath().toString());
                String type = step.getType();
                int pos = type.indexOf("$$ Enhancer");
                if (pos > 0) {
                    type = type.substring(0, pos);
                }
                row.setValue("stepType", (Object)type);
                row.setValue("duration", (Object)step.getDuration());
                row.setValue("status", (Object)step.getStatus().toString());
                row.setValue("successed", (Object)(step.getStatus() == StepRuntime.Status.SUCCESSFUL ? 1 : 0));
            }
            this.getContext().setDestReport(destReport);
            db.saveReport(destReport);
        }
        finally {
            db.close();
        }
    }
}

