/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.utils;

import com.collabnet.ce.soap50.types.SoapFieldValues;
import com.collabnet.ce.soap50.webservices.tracker.Artifact2SoapDO;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;

public class CTFUtils {
    private static Map<String, String> mimeTypes = new HashMap<String, String>(120);

    public static SoapFieldValues createFlexFieldValues(Map<String, String> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        ArrayList names = Lists.newArrayList();
        ArrayList values = Lists.newArrayList();
        ArrayList types = Lists.newArrayList();
        for (String each : fields.keySet()) {
            if (!each.toLowerCase().startsWith("flex:")) continue;
            String value = fields.get(each);
            String name = fields instanceof CaseInsensitiveMap ? ((CaseInsensitiveMap)fields).getOriginalKey(each).substring("flex:".length()) : each.substring("flex:".length());
            if (Strings.isNullOrEmpty((String)name)) continue;
            names.add(name.replaceAll("_", " "));
            values.add(value);
            types.add("String");
        }
        SoapFieldValues flexFields = null;
        if (names.size() > 0) {
            flexFields = new SoapFieldValues();
            flexFields.setNames((String[])Iterables.toArray((Iterable)names, String.class));
            flexFields.setTypes((String[])Iterables.toArray((Iterable)types, String.class));
            flexFields.setValues(Iterables.toArray((Iterable)values, Object.class));
        }
        return flexFields;
    }

    public static ArtifactSoapDO updateArtifact2(ArtifactSoapDO asd, Map<String, String> map) {
        SoapFieldValues flexFields;
        if (map.containsKey("assignee")) {
            asd.setAssignedTo(MapUtils.getString(map, (Object)"assignee"));
        }
        if (map.containsKey("category")) {
            asd.setCategory(MapUtils.getString(map, (Object)"category"));
        }
        if (map.containsKey("customer")) {
            asd.setCustomer(MapUtils.getString(map, (Object)"customer"));
        }
        if (map.containsKey("description")) {
            asd.setDescription(MapUtils.getString(map, (Object)"description"));
        }
        if (map.containsKey("folderId")) {
            asd.setFolderId(MapUtils.getString(map, (Object)"folderId"));
        }
        if (map.containsKey("group")) {
            asd.setGroup(MapUtils.getString(map, (Object)"group"));
        }
        if (map.containsKey("priority")) {
            asd.setPriority(Integer.valueOf(MapUtils.getString(map, (Object)"priority")).intValue());
        }
        if (map.containsKey("reportedIn")) {
            asd.setReportedReleaseId(MapUtils.getString(map, (Object)"reportedIn"));
        }
        if (map.containsKey("fixedIn")) {
            asd.setResolvedReleaseId(MapUtils.getString(map, (Object)"fixedIn"));
        }
        if (map.containsKey("status")) {
            asd.setStatus(MapUtils.getString(map, (Object)"status"));
        }
        if (map.containsKey("title")) {
            asd.setTitle(MapUtils.getString(map, (Object)"title"));
        }
        if ((flexFields = CTFUtils.createFlexFieldValues(map)) != null) {
            asd.setFlexFields(flexFields);
        }
        return asd;
    }

    public static Artifact2SoapDO updateArtifact2(Artifact2SoapDO asd, Map<String, String> map) {
        SoapFieldValues flexFields;
        if (map.containsKey("actualEffort")) {
            asd.setActualEffort(Integer.valueOf(MapUtils.getString(map, (Object)"actualEffort")).intValue());
        }
        if (map.containsKey("assignee")) {
            asd.setAssignedTo(MapUtils.getString(map, (Object)"assignee"));
        }
        if (map.containsKey("autosumming")) {
            asd.setAutosumming(Boolean.valueOf(MapUtils.getString(map, (Object)"autosumming")).booleanValue());
        }
        if (map.containsKey("category")) {
            asd.setCategory(MapUtils.getString(map, (Object)"category"));
        }
        if (map.containsKey("customer")) {
            asd.setCustomer(MapUtils.getString(map, (Object)"customer"));
        }
        if (map.containsKey("description")) {
            asd.setDescription(MapUtils.getString(map, (Object)"description"));
        }
        if (map.containsKey("estimatedEffort")) {
            asd.setEstimatedEffort(Integer.valueOf(MapUtils.getString(map, (Object)"estimatedEffort")).intValue());
        }
        if (map.containsKey("folderId")) {
            asd.setFolderId(MapUtils.getString(map, (Object)"folderId"));
        }
        if (map.containsKey("group")) {
            asd.setGroup(MapUtils.getString(map, (Object)"group"));
        }
        if (map.containsKey("planningFolder")) {
            asd.setPlanningFolderId(MapUtils.getString(map, (Object)"planningFolder"));
        }
        if (map.containsKey("priority")) {
            asd.setPriority(Integer.valueOf(MapUtils.getString(map, (Object)"priority")).intValue());
        }
        if (map.containsKey("reportedIn")) {
            asd.setReportedReleaseId(MapUtils.getString(map, (Object)"reportedIn"));
        }
        if (map.containsKey("fixedIn")) {
            asd.setResolvedReleaseId(MapUtils.getString(map, (Object)"fixedIn"));
        }
        if (map.containsKey("status")) {
            asd.setStatus(MapUtils.getString(map, (Object)"status"));
        }
        if (map.containsKey("title")) {
            asd.setTitle(MapUtils.getString(map, (Object)"title"));
        }
        if ((flexFields = CTFUtils.createFlexFieldValues(map)) != null) {
            asd.setFlexFields(flexFields);
        }
        return asd;
    }

    public static String getMimeType(String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        String type = mimeTypes.get(ext);
        if (type == null) {
            return "application/octet-stream";
        }
        return type;
    }

    static {
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("asc", "text/plain");
        mimeTypes.put("asf", "application/x-ms-asf");
        mimeTypes.put("asx", "application/x-ms-asf");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("avi", "video/x-msvideo");
        mimeTypes.put("bin", "application/octet-stream");
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("bwf", "audio/wav");
        mimeTypes.put("bz2", "application/x-bzip2");
        mimeTypes.put("c", "text/plain");
        mimeTypes.put("cc", "text/plain");
        mimeTypes.put("cdda", "audio/x-aiff");
        mimeTypes.put("class", "application/octet-stream");
        mimeTypes.put("com", "application/octet-stream");
        mimeTypes.put("cpp", "text/plain");
        mimeTypes.put("cpr", "image/cpr");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dot", "application/msword");
        mimeTypes.put("dtd", "text/xml");
        mimeTypes.put("ear", "application/zip");
        mimeTypes.put("exe", "application/octet-stream");
        mimeTypes.put("flc", "video/flc");
        mimeTypes.put("fm", "application/x-maker");
        mimeTypes.put("frame", "application/x-maker");
        mimeTypes.put("frm", "application/x-maker");
        mimeTypes.put("h", "text/plain");
        mimeTypes.put("hh", "text/plain");
        mimeTypes.put("hpp", "text/plain");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gz", "application/x-gunzip");
        mimeTypes.put("ico", "image/x-icon");
        mimeTypes.put("iso", "application/octet-stream");
        mimeTypes.put("jar", "application/zip");
        mimeTypes.put("java", "text/plain");
        mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("js", "text/x-javascript");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("maker", "application/x-maker");
        mimeTypes.put("mid", "audio/midi");
        mimeTypes.put("midi", "audio/midi");
        mimeTypes.put("mim", "application/mime");
        mimeTypes.put("mime", "application/mime");
        mimeTypes.put("mov", "video/quicktime");
        mimeTypes.put("mp2", "audio/mpeg");
        mimeTypes.put("mp3", "audio/mpeg");
        mimeTypes.put("mp4", "video/mpeg4");
        mimeTypes.put("mpa", "video/mpeg");
        mimeTypes.put("mpe", "video/mpeg");
        mimeTypes.put("mpeg", "video/mpeg");
        mimeTypes.put("mpg", "video/mpeg");
        mimeTypes.put("mpga", "audio/mpeg");
        mimeTypes.put("mpm", "video/mpeg");
        mimeTypes.put("mpv", "video/mpeg");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("pic", "image/x-pict");
        mimeTypes.put("pict", "image/x-pict");
        mimeTypes.put("pct", "image/x-pict");
        mimeTypes.put("pl", "application/x-perl");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("pnm", "image/x-portable-anymap");
        mimeTypes.put("pbm", "image/x-portable-bitmap");
        mimeTypes.put("ppm", "image/x-portable-pixmap");
        mimeTypes.put("ps", "application/postscript");
        mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypes.put("qt", "video/quicktime");
        mimeTypes.put("ra", "application/vnd.rn-realaudio");
        mimeTypes.put("rar", "application/zip");
        mimeTypes.put("rf", "application/vnd.rn-realflash");
        mimeTypes.put("ra", "audio/vnd.rn-realaudio");
        mimeTypes.put("ram", "audio/x-pn-realaudio");
        mimeTypes.put("rm", "application/vnd.rn-realmedia");
        mimeTypes.put("rmm", "audio/x-pn-realaudio");
        mimeTypes.put("rsml", "application/vnd.rn-rsml");
        mimeTypes.put("rtf", "text/rtf");
        mimeTypes.put("rv", "video/vnd.rn-realvideo");
        mimeTypes.put("spl", "application/futuresplash");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("ssm", "application/smil");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("tgz", "application/x-gtar");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("ulw", "audio/basic");
        mimeTypes.put("war", "application/zip");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("wax", "application/x-ms-wax");
        mimeTypes.put("wm", "application/x-ms-wm");
        mimeTypes.put("wma", "application/x-ms-wma");
        mimeTypes.put("wml", "text/wml");
        mimeTypes.put("wmw", "application/x-ms-wmw");
        mimeTypes.put("wrd", "application/msword");
        mimeTypes.put("wvx", "application/x-ms-wvx");
        mimeTypes.put("xbm", "image/x-xbitmap");
        mimeTypes.put("xpm", "image/image/x-xpixmap");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("xsl", "text/xml");
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("z", "application/x-compress");
        mimeTypes.put("Z", "application/x-compress");
    }
}

