/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step.issueupdater;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueupdater.AbstractListUpdater;
import java.util.Collections;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Update artifacts with specified ids", order=30)
public class SpecifiedListUpdater
extends AbstractListUpdater {
    private static final long serialVersionUID = 1L;
    private String keyList;

    @Editable(name="Artifact Ids", order=100, description="Specify the artifact ids you want to update, space to separate each other.")
    @NotEmpty
    @Scriptable
    public String getKeyList() {
        return this.keyList;
    }

    public void setKeyList(String keys) {
        this.keyList = keys;
    }

    protected Set<String> getIssueKeys() {
        String ids = this.getKeyList();
        if (Strings.isNullOrEmpty((String)ids)) {
            return Collections.emptySet();
        }
        return Sets.newLinkedHashSet((Iterable)Splitter.on((char)' ').omitEmptyStrings().trimResults().split((CharSequence)ids));
    }
}

