/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step.issueupdater;

import com.collabnet.ce.soap50.webservices.tracker.Artifact2SoapDO;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommandDef;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractCommitCommandUpdater;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.teamforge.TeamForgeTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFIssue;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueupdater.ArtifactUpdater;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueupdater.CTFCommandDef;
import com.pmease.quickbuild.plugin.tracker.teamforge.utils.CTFUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import org.apache.commons.collections.MapUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;

@Editable(name="Update artifacts by commit commands", order=10)
public class CTFCommandUpdater
extends AbstractCommitCommandUpdater
implements ArtifactUpdater {
    private static final long serialVersionUID = 1L;
    private List<CTFCommandDef> commandDefs;
    private transient CollabNetApp app;

    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.app = CollabNetApp.newInstance();
    }

    protected void onAfterUpdate() {
        super.onAfterUpdate();
        CollabNetApp.closeQuietly(this.app);
    }

    protected List<? extends CommitCommandDef> getCommitCommandDefs() {
        return this.getCommandDefs();
    }

    protected void initCommandDefs() {
        this.commandDefs = Lists.newArrayList();
        this.commandDefs.add(new CTFCommandDef("update", ""));
        this.commandDefs.add(new CTFCommandDef("accept", "assignee=${step.getTrackerUser()}"));
        this.commandDefs.add(new CTFCommandDef("fix", "status=Fixed"));
    }

    protected void executeCommand() {
        Logger logger = Context.getLogger();
        CommitCommand command = this.getCurrentCommand();
        String id = command.getIssue();
        CTFIssue issue = this.app.getIssue(id);
        Map options = StringHelper.getOptionsFromDefinition((String)this.step.getExtraAttributes());
        options.putAll(command.getOptions());
        Artifact2SoapDO asd = this.app.getArtifact2Soap(command.getIssue());
        asd = CTFUtils.updateArtifact2(asd, (Map<String, String>)options);
        Date commitDate = command.getDate();
        Calendar updated = issue.getUpdated();
        if (updated != null && updated.getTime().after(commitDate)) {
            throw new TrackerException("This issue has been updated after commit.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Updating artifact [" + id + "] via command: " + command);
        }
        this.app.updateIssue(asd, MapUtils.getString((Map)options, (Object)"comment"));
    }

    protected AbstractIssueTracker createTracker() {
        return new TeamForgeTracker();
    }

    @Editable(name="Commit Commands", order=1500, description="QuickBuild will search for defined commands in SCM commit messages, and update associated artifacts using specified attributes. For example, if command \"fix\" is defined to update the artifact status to Fixed, occurrence of \"fix artf1100\" in commit messages will be interpreted as resolving artifact \"artf1100\" in current build. Refer to <a href=\"$docroot/Commit+Command\" target=\"_blank\">command syntax</a> on how to use defined commands in commit messages.<br/><strong>NOTE:</strong> Commit commands are case-insensitive.")
    @Size(min=1, max=1000)
    @NotEmpty
    @Scriptable
    @ScriptApi
    public List<CTFCommandDef> getCommandDefs() {
        return this.commandDefs;
    }

    public void setCommandDefs(List<CTFCommandDef> commandDefs) {
        this.commandDefs = commandDefs;
    }
}

