/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step.issueprovider;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFIssue;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueprovider.ArtifactProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Artifacts filtered by specified query string", order=20)
public class FilteredProvider
implements ArtifactProvider {
    private static final long serialVersionUID = 1L;
    private String queryString;

    @Editable(name="Query String", order=100, description="Specify the query string which is followed lucene search syntax, see http://lucene.apache.org/java/2_3_2/queryparsersyntax.html for details.")
    @NotEmpty
    @Scriptable
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIssueKeys() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        CollabNetApp app = CollabNetApp.newInstance();
        try {
            List<CTFIssue> issues = app.findIssues(setting.getProjectId(), this.getQueryString());
            LinkedHashSet keys = Sets.newLinkedHashSet();
            for (CTFIssue each : issues) {
                keys.add(each.getIssueKey());
            }
            LinkedHashSet linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            CollabNetApp.closeQuietly(app);
        }
    }
}

