/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFDocument;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFDocumentFolder;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.utils.CTFUtils;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Upload Files to TeamForge", category={"Issue Tracker"}, description="The step is to upload files to TeamForge documents folder.")
@ScriptApi(value="This step can be used to upload files to TeamForge documents folder.")
public class UploadFilesStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcDir;
    private String filePattern;
    private String rootFolder;
    private boolean overwrite = true;
    private boolean preserveStructure = true;
    private String docStatus = "draft";
    private boolean createLocked;
    private String docDescription;
    private String versionComment;

    public void run() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        Preconditions.checkNotNull((Object)((Object)setting), (Object)"TeamForge setting should be defined.");
        File workspaceDir = Context.getBuild().getConfiguration().getWorkspaceDir();
        File baseDir = !Strings.isNullOrEmpty((String)this.getSrcDir()) ? new File(workspaceDir, this.getSrcDir()) : workspaceDir;
        CollabNetApp app = CollabNetApp.newInstance();
        CTFProject project = app.getProjectById(setting.getProjectId());
        Collection files = FileUtils.listFiles((File)baseDir, (String)this.getFilePattern());
        String rootPath = this.getRootFolder();
        if (Strings.isNullOrEmpty((String)rootPath)) {
            rootPath = project.getRootFolder().getPath();
        }
        rootPath = StringUtils.stripEnd((String)rootPath, (String)"/");
        for (File each : files) {
            if (!each.isFile()) continue;
            File dir = each.getParentFile();
            String relativePath = FileUtils.getRelativePath((String)dir.getAbsolutePath(), (String)baseDir.getAbsolutePath());
            relativePath = StringUtils.replace((String)relativePath, (String)"\\", (String)"/");
            CTFDocumentFolder folder = project.getOrCreateDocumentFolder(rootPath + "/" + StringUtils.stripStart((String)relativePath, (String)"/"));
            String title = FilenameUtils.getName((String)each.getAbsolutePath());
            CTFDocument doc = folder.getDocuments().byTitle(title);
            CTFFile file = app.upload(each);
            if (doc == null) {
                folder.createDocument(title, this.getDocDescription(), null, this.getDocStatus(), this.isCreateLocked(), title, CTFUtils.getMimeType(title), file, null, null);
                continue;
            }
            doc.update(file);
        }
    }

    @Editable(name="Publish to Folder", order=1000, description="Specify the TeamForge document folder path. For example, Build Results/V1.0.2. Leave empty if you want to use the root folder. QuickBuild will create the folder if it is not existed in TeamForge.")
    @Scriptable
    @ScriptApi(value="Get the root folder")
    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Editable(name="Source directory", order=1100, description="Specify the directory which you want to publish the files. The directory specified here is relative to workspace directory. Leave empty if you want to use workspace directory.")
    @Scriptable
    @ScriptApi(value="Get the source directory")
    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String srcDir) {
        this.srcDir = srcDir;
    }

    @Editable(name="File pattern", order=1200, description="Specify a file pattern so that files that match the pattern are uploaded. For example, \"doc/**\". Refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @NotEmpty
    @ScriptApi(value="Get file pattern.")
    @Scriptable
    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @Editable(name="Preserve Directory Structure", order=1230, description="Whether create sub-folders or not. When set to true, QuickBuild will create the sub-folders according to the source directory, otherwise, all files will be uploaded to the folder specified above.")
    @Scriptable
    @ScriptApi(value="Get preserve structure or not.")
    public boolean isPreserveStructure() {
        return this.preserveStructure;
    }

    public void setPreserveStructure(boolean preserveStructure) {
        this.preserveStructure = preserveStructure;
    }

    @Editable(name="Overwrite existed", order=1250, description="Specify whether overwrite existed documents or not.")
    @ScriptApi
    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Editable(name="Document Status", order=1300, description="Specify the document status when upload to TeamForge")
    @NotEmpty
    @ExpressionProvider(value="getAvailableDocStatuses")
    @Scriptable
    @ScriptApi(value="Get created document status")
    public String getDocStatus() {
        return this.docStatus;
    }

    public void setDocStatus(String docStatus) {
        this.docStatus = docStatus;
    }

    @Editable(name="Lock Document", order=1400, description="Specify whether lock document or not.")
    public boolean isCreateLocked() {
        return this.createLocked;
    }

    public void setCreateLocked(boolean createLocked) {
        this.createLocked = createLocked;
    }

    @Editable(name="Document Description", order=1500)
    @NotEmpty
    @Multiline
    @Scriptable
    @ScriptApi
    public String getDocDescription() {
        return this.docDescription;
    }

    public void setDocDescription(String docDescription) {
        this.docDescription = docDescription;
    }

    @Editable(name="Version Comment", order=1600)
    @Multiline
    @Scriptable
    @ScriptApi
    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public static Map<String, String> getAvailableDocStatuses() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("draft", "draft");
        map.put("final", "final");
        return map;
    }
}

