/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractUpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.IssueUpdater;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFPlugin;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.ArtifactUpdaterWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Update TeamForge Artifacts", category={"Issue Tracker"}, description="This step updates TeamForge artifacts based on commit commands  found in SCM commit messages since previous successful build, TeamForge filter or any specified issue list<br/><strong>NOTE:</strong><ul class=\"square\">   <li>Normally, this step should be arranged to run before the \"release version\" step if you want to    release this build into TeamForge.</li>\t<li>The artifacts are updated by the account which is specified in the TeamForge setting</li>\t<li>If artifacts to be updated are based on commit commands, the artifacts updated manually after commit will not be processed here.</li>\t<li>Only artifacts belonging to associated TeamForge project will be processed.</li></ul>")
@ScriptApi(value="This step updates TeamForge artifacts based commit commands found in SCM commit messages since previous successful build.")
public class UpdateArtifactStep
extends AbstractUpdateIssueStep {
    private static final long serialVersionUID = 1L;
    private List<ArtifactUpdaterWrapper> updaterWrappers = Lists.newArrayList();

    protected List<IssueUpdater> getUpdaters() {
        ArrayList<IssueUpdater> updaters = new ArrayList<IssueUpdater>();
        for (ArtifactUpdaterWrapper each : this.getUpdaterWrappers()) {
            updaters.add(each.getUpdater());
        }
        return updaters;
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return CTFPlugin.class;
    }

    @Editable(name="Specify How to Update Artifacts", order=1000)
    @Size(min=1, max=10000)
    public List<ArtifactUpdaterWrapper> getUpdaterWrappers() {
        return this.updaterWrappers;
    }

    public void setUpdaterWrappers(List<ArtifactUpdaterWrapper> updaterWrappers) {
        this.updaterWrappers = updaterWrappers;
    }

    @Editable(name="Extra Attributes", order=1600, description="Optionally specify extra attributes for updating artifacts, with one attribute per line.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes for updating artifacts.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }
}

