/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step;

import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractReleaseVersionStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueprovider.IssueProvider;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFPlugin;
import com.pmease.quickbuild.plugin.tracker.teamforge.TeamForgeTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFPackage;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFRelease;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFReleaseFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueprovider.ArtifactProviderWrapper;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.issueprovider.CommitMessageProvider;
import com.pmease.quickbuild.plugin.tracker.teamforge.utils.CTFUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create TeamForge Release", category={"Issue Tracker"}, description="This step can be used to:<ol>  <li>create a release to the specified package</li>  <li>publish files to the release</li>  <li>update 'Fixed in Release' field of the specified artifacts</li></ol><strong>NOTE:</strong><ul class=\"square\">   <li>Only Fixed/Closed artifacts will be updated</li>\t<li>The user defined in TeamForge Setting must have permission to administer project and edit project artifacts.</li></ul>")
@ScriptApi(value="The step can be used to create a release to TeamForge.")
public class CreateReleaseStep
extends AbstractReleaseVersionStep {
    private static final long serialVersionUID = 1L;
    private String toPackage;
    private String releaseName = "${build.version}";
    private String releaseDescription;
    private String releaseStatus = "Active";
    private String releaseMaturity;
    private String statusWanted = "Fixed,Closed";
    private String filePattern;
    private boolean overwrite = true;
    private List<ArtifactProviderWrapper> wrappers = Lists.newArrayList();
    private transient CollabNetApp app;
    private transient CTFProject project;
    private transient String releaseId;

    public CreateReleaseStep() {
        ArtifactProviderWrapper wrapper = new ArtifactProviderWrapper();
        wrapper.setProvider(new CommitMessageProvider());
        this.wrappers.add(wrapper);
    }

    protected void onBeforeRelease() {
        this.app = CollabNetApp.newInstance();
        TeamForgeSetting setting = TeamForgeSetting.get();
        Preconditions.checkNotNull((Object)((Object)setting));
        this.project = this.app.getProjectById(setting.getProjectId());
        Preconditions.checkNotNull((Object)this.project, (Object)("Cannot find project " + setting.getProjectId() + "."));
    }

    protected void onAfterRelease() {
        CollabNetApp.closeQuietly(this.app);
    }

    protected IssueTracker getIssueTracker() {
        return new TeamForgeTracker();
    }

    protected void releaseVersion() {
        String pkg = this.getToPackage();
        CTFList<CTFPackage> packages = this.project.getPackages();
        CTFPackage thePackage = packages.byId(pkg);
        if (thePackage == null) {
            thePackage = packages.byTitle(pkg);
        }
        Preconditions.checkNotNull((Object)thePackage, (Object)("Pakcage " + pkg + " does not exist in project " + this.project.getId()));
        CTFRelease release = thePackage.getReleaseByTitle(this.getReleaseName());
        if (release != null) {
            Context.getLogger().warn("The release " + release + " is already exist.");
        } else {
            release = thePackage.createRelease(this.getReleaseName(), this.getReleaseDescription(), this.getReleaseStatus().toLowerCase(), this.getReleaseMaturity());
        }
        this.releaseId = release.getId();
        Context.getLogger().info("Release - " + release.getTitle() + " is created.");
        File workspaceDir = Context.getBuild().getConfiguration().getWorkspaceDir().getAbsoluteFile();
        Collection files = FileUtils.listFiles((File)workspaceDir, (String)this.getFilePattern());
        for (File each : files) {
            if (!each.isFile()) continue;
            String name = FilenameUtils.getName((String)each.getAbsolutePath());
            CTFReleaseFile existedFile = release.getFileByTitle(name);
            if (existedFile != null) {
                if (this.isOverwrite()) {
                    existedFile.delete();
                } else {
                    Context.getLogger().info("File " + existedFile + " already exists, ignore uploading to server.");
                    continue;
                }
            }
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Publishing file " + each + " ...");
            }
            CTFFile file = this.app.upload(each);
            release.addFile(name, CTFUtils.getMimeType(each.getAbsolutePath()), file);
        }
    }

    protected void updateIssue(String key) {
        ArtifactSoapDO asd = this.project.getArtifact(key);
        if (asd == null) {
            return;
        }
        HashSet wanted = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)this.getStatusWanted())) {
            wanted = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.getStatusWanted()));
        }
        if (wanted.isEmpty() || wanted.contains(asd.getStatus())) {
            Map attributes = StringHelper.getOptionsFromDefinition((String)this.getExtraAttributes());
            asd = CTFUtils.updateArtifact2(asd, (Map<String, String>)attributes);
            asd.setResolvedReleaseId(this.releaseId);
            this.app.updateIssue(asd, null);
        }
    }

    protected List<IssueProvider> getProviders() {
        ArrayList providers = Lists.newArrayList();
        for (ArtifactProviderWrapper each : this.getWrappers()) {
            providers.add(each.getProvider());
        }
        return providers;
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return CTFPlugin.class;
    }

    @Editable(name="Release to package", order=1000)
    @ExpressionProvider(value="getAvailablePackages")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get release to which package.")
    public String getToPackage() {
        return this.toPackage;
    }

    public void setToPackage(String toPackage) {
        this.toPackage = toPackage;
    }

    @Editable(name="Release Name", order=1100)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get release name")
    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    @Editable(name="Release Description", order=1200)
    @Multiline
    @Scriptable
    @ScriptApi(value="Get release description")
    public String getReleaseDescription() {
        return this.releaseDescription;
    }

    public void setReleaseDescription(String releaseDescription) {
        this.releaseDescription = releaseDescription;
    }

    @Editable(name="Release Status", order=1300)
    @ExpressionProvider(value="getAvailableReleaseStatuses")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get release status")
    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setReleaseStatus(String releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    @Editable(name="Release Maturity", order=1400)
    @ExpressionProvider(value="getAvailableReleaseMaturities")
    @Scriptable
    @ScriptApi(value="Get release maturity")
    public String getReleaseMaturity() {
        return this.releaseMaturity;
    }

    public void setReleaseMaturity(String releaseMaturity) {
        this.releaseMaturity = releaseMaturity;
    }

    @Editable(name="Files to release", order=1500, description="Specify the file pattern here. QuickBuild will publish those files to the created release in TeamForge. Path specified here is related to workspace.Refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @Scriptable
    @ScriptApi(value="Get file pattern")
    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePatterns) {
        this.filePattern = filePatterns;
    }

    @Editable(name="Overwrite existed files", order=1600, description="Specify whether overwrite the existed files or not.")
    @ScriptApi(value="Whether overwrite existed files or not.")
    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Editable(name="Artifacts to Update", order=1700, description="Specify which artifacts will be updated.")
    public List<ArtifactProviderWrapper> getWrappers() {
        return this.wrappers;
    }

    public void setWrappers(List<ArtifactProviderWrapper> wrappers) {
        this.wrappers = wrappers;
    }

    @Editable(name="Artifacts with status", order=1800, description="Only artifacts with specified status will be updated. Comma to separate each. Leave empty to update all.")
    @Scriptable
    public String getStatusWanted() {
        return this.statusWanted;
    }

    public void setStatusWanted(String statusWanted) {
        this.statusWanted = statusWanted;
    }

    @Editable(order=1800, name="Extra Attributes", description="Optionally specify extra attributes when update artifacts, with one attribute per line. For example:<br/><code>assignee=admin<br/>comment=updated by QuickBuild</code>Reference <a href=\"$docroot/Integrating+JIRA+with+QuickBuild\" target=\"_default\">here</a> for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes used when update the \"fix version/s\" field of applicable issues.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getAvailablePackages() {
        LinkedHashMap linkedHashMap;
        TeamForgeSetting setting = TeamForgeSetting.get();
        if (setting == null) {
            return Collections.emptyMap();
        }
        CollabNetApp app = null;
        try {
            app = new CollabNetApp(setting);
            CTFList<CTFPackage> packages = app.getPackages(setting.getProjectId());
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (CTFPackage each : packages) {
                map.put(each.getTitle(), each.getTitle());
            }
            linkedHashMap = map;
        }
        catch (TrackerException e) {
            Map<String, String> map;
            try {
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                CollabNetApp.closeQuietly(app);
                throw throwable;
            }
            CollabNetApp.closeQuietly(app);
            return map;
        }
        CollabNetApp.closeQuietly(app);
        return linkedHashMap;
    }

    private static Map<String, String> getAvailableReleaseStatuses() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("Active", "Active");
        map.put("Pending", "Pending");
        return map;
    }

    private static Map<String, String> getAvailableReleaseMaturities() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("None", "");
        map.put("Prototype", "Prototype");
        map.put("Development Build", "Development Build");
        map.put("Alpha", "Alpha");
        map.put("Beta", "Beta");
        map.put("Early Access", "Early Access");
        map.put("Pre-General Availability", "Pre-General Availability");
        map.put("General Availability", "General Availability");
        map.put("Stable", "Stable");
        map.put("Obsolete", "Obsolete");
        return map;
    }
}

