/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.step;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFPlugin;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFIssue;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.setting.step.executecondition.AnyPreviousSiblingStepFailed;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create TeamForge Artifact", category={"Issue Tracker"}, description="This step can be used to create artifact in associated CollabNet TeamForge project.")
@ScriptApi(value="The step can be used to create an artifact in associated TeamForge project.")
public class CreateArtifactStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String artifactTitle;
    private String artifactDescription;
    private String trackerName;
    private String artifactStatus;
    private int artifactPriority = 3;
    private String assignedTo;

    public CreateArtifactStep() {
        this.setExecuteCondition((ExecuteCondition)new AnyPreviousSiblingStepFailed());
        this.artifactTitle = "Build ${build.getVersion()} failed!";
        this.trackerName = "Defects";
        this.artifactStatus = "Open";
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return CTFPlugin.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        if (setting == null) {
            throw new QuickbuildException("TeamForge setting is not configured properly in the configuration. To configure TeamForge setting, please go to Configuration settings -> TeamForge Server tab panel.");
        }
        String extraOptions = this.getExtraAttributes();
        Map fields = StringHelper.getOptionsFromDefinition((String)extraOptions);
        CollabNetApp app = null;
        try {
            this.onBeforeRun();
            app = new CollabNetApp(setting);
            CTFIssue issue = app.createArtifact(setting.getProjectId(), this.getTrackerName(), this.getArtifactTitle(), this.getArtifactDescription(), this.getArtifactStatus(), this.getArtifactPriority(), this.getAssignedTo(), fields);
            this.getIssueActions().put(issue.getIssueKey(), "created");
            Context.getLogger().info("Artifact: " + issue.getIssueKey() + " created successfully.");
            this.onAfterRun();
        }
        catch (Throwable throwable) {
            CollabNetApp.closeQuietly(app);
            throw throwable;
        }
        CollabNetApp.closeQuietly(app);
    }

    @Editable(name="Artifact Title", order=1100, description="Specify the issue/artifact title")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get artifact title.")
    public String getArtifactTitle() {
        return this.artifactTitle;
    }

    public void setArtifactTitle(String issueTitle) {
        this.artifactTitle = issueTitle;
    }

    @Editable(name="Artifact Description", order=1200, description="Optionally specify the artifact description, leave empty if it is same as title")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get artifact description.")
    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public void setArtifactDescription(String issueDescription) {
        this.artifactDescription = issueDescription;
    }

    @Editable(name="Tracker Name", order=1300, description="Specify the tracker name which you want to create the artifact to, for example, Defects; Stories; etc.")
    @NotEmpty
    @ExpressionProvider(value="getAvailableTrackerNames")
    @Scriptable
    @ScriptApi(value="Get the tracker name")
    public String getTrackerName() {
        return this.trackerName;
    }

    public void setTrackerName(String trackerName) {
        this.trackerName = trackerName;
    }

    @Editable(name="Artifact Status", order=1400, description="Specify the status of the artifact")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get the artifact status")
    public String getArtifactStatus() {
        return this.artifactStatus;
    }

    public void setArtifactStatus(String issueStatus) {
        this.artifactStatus = issueStatus;
    }

    @Editable(name="Artifact Priority", order=1500, description="Specify the priority of this artifact")
    @Scriptable
    @ScriptApi(value="Get the artifact priority")
    public int getArtifactPriority() {
        return this.artifactPriority;
    }

    public void setArtifactPriority(int issuePriority) {
        this.artifactPriority = issuePriority;
    }

    @Editable(name="Assigned To", order=1600, description="Specify the user name this artifact should be assigned to")
    @Scriptable
    @ScriptApi(value="Get the user name this artifact should be assigned to")
    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    @Editable(order=2000, name="Extra Attributes", description="Optionally specify extra attributes of the artifact, with one attribute per line. For example:<br/><code>customer=some_customer</code>Valid attributes include:<br/><ul>\t<li>group: specify the group</li>\t<li>category: specify the category</li>\t<li>customer: specify the customer</li>\t<li>estimatedEffort: specify the estimated effort in hours</li>\t<li>remainingEffort: specify the remaining effort in hours</li>\t<li>autosumming: specify whether auto summing the effort or not, true or false</li>\t<li>releaseId: specify the release id</li>\t<li>planningFolder: specify the planning folder id</li></ul><br/>If you want to specify the flex fields, please add <i>flex:</i> as the prefix before the flex field name,for example, to specify flex field <i>My Custom Field</i>, you may input as the following:<code>flex:My Custom Field=Hello, custom field</code>.<b>Note:</b> for custom field, only String type field is supported.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes of the issue.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getAvailableTrackerNames() {
        LinkedHashMap linkedHashMap;
        TeamForgeSetting setting = TeamForgeSetting.get();
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (setting == null) {
            return map;
        }
        CollabNetApp app = null;
        try {
            app = new CollabNetApp(setting);
            CTFProject project = app.getProjectById(setting.getProjectId());
            List<String> list = project.getTrackerNames();
            for (String each : list) {
                map.put(each, each);
            }
            linkedHashMap = map;
        }
        catch (Throwable throwable) {
            CollabNetApp.closeQuietly(app);
            throw throwable;
        }
        CollabNetApp.closeQuietly(app);
        return linkedHashMap;
    }
}

