/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.renderer;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueReportPanel;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.teamforge.TeamForgeTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.renderer.LinkIssueToolbar;
import com.pmease.quickbuild.plugin.tracker.teamforge.renderer.TrackerBean;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.model.IModel;

public class TeamForgeReportPanel
extends IssueReportPanel {
    private static final long serialVersionUID = 1L;
    private Map<String, TrackerBean> trackers = Maps.newHashMap();
    private boolean connectionFailed = false;

    public TeamForgeReportPanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        this.initTrackerConstants();
    }

    protected IssueTracker getTracker() {
        return new TeamForgeTracker();
    }

    protected boolean isConnectionFailed() {
        return this.connectionFailed;
    }

    protected void addToolbars(DataGrid dataGrid) {
        dataGrid.addTopToolbar((AbstractToolbar)new LinkIssueToolbar(dataGrid, ""));
        super.addToolbars(dataGrid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTrackerConstants() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        if (setting == null) {
            this.dataGrid.error((Serializable)((Object)"No TeamForge setting defined for current configuration."));
            this.connectionFailed = true;
            return;
        }
        CollabNetApp app = null;
        try {
            app = new CollabNetApp(setting);
            CTFProject project = app.getProjectById(setting.getProjectId());
            CTFList<CTFTracker> list = project.getTrackers();
            this.trackers = Maps.newHashMap();
            for (CTFTracker each : list) {
                TrackerBean bean = new TrackerBean();
                bean.setId(each.getId());
                bean.setTitle(each.getTitle());
                if (!Strings.isNullOrEmpty((String)each.getIcon())) {
                    bean.setIcon(StringHelper.normalizeUrl((String)setting.getHost()) + "/sf-images/tracker/icons/" + each.getIcon());
                }
                this.trackers.put(each.getId(), bean);
            }
        }
        catch (TrackerException e) {
            try {
                this.connectionFailed = true;
                this.dataGrid.error((Serializable)((Object)("Connect to TeamForge server failed due to: " + ExceptionUtils.extractImportantMessage((Throwable)e))));
            }
            catch (Throwable throwable) {
                CollabNetApp.closeQuietly(app);
                throw throwable;
            }
            CollabNetApp.closeQuietly(app);
        }
        CollabNetApp.closeQuietly(app);
    }

    public Map<String, TrackerBean> getTrackers() {
        return this.trackers;
    }
}

