/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.fault.NoSuchObjectFault;
import com.collabnet.ce.soap50.webservices.ClientSoapStubFactory;
import com.collabnet.ce.soap50.webservices.cemain.Group2SoapList;
import com.collabnet.ce.soap50.webservices.cemain.Group2SoapRow;
import com.collabnet.ce.soap50.webservices.cemain.ICollabNetSoap;
import com.collabnet.ce.soap50.webservices.cemain.ProjectSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapList;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap50.webservices.docman.IDocumentAppSoap;
import com.collabnet.ce.soap50.webservices.filestorage.IFileStorageAppSoap;
import com.collabnet.ce.soap50.webservices.frs.IFrsAppSoap;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapDO;
import com.collabnet.ce.soap50.webservices.planning.IPlanningAppSoap;
import com.collabnet.ce.soap50.webservices.planning.PlanningFolderSoapDO;
import com.collabnet.ce.soap50.webservices.rbac.IRbacAppSoap;
import com.collabnet.ce.soap50.webservices.scm.IScmAppSoap;
import com.collabnet.ce.soap50.webservices.tracker.Artifact2SoapDO;
import com.collabnet.ce.soap50.webservices.tracker.Artifact2SoapList;
import com.collabnet.ce.soap50.webservices.tracker.Artifact2SoapRow;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.soap50.webservices.tracker.ITrackerAppSoap;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFGroup;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFIssue;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFPackage;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFUser;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.utils.CTFUtils;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis.AxisFault;
import org.apache.commons.collections.MapUtils;

public class CollabNetApp {
    public static String SOAP_SERVICE = "/ce-soap50/services/";
    private String sessionId;
    private String username;
    private String url;
    protected final ICollabNetSoap icns;
    private volatile IFrsAppSoap ifrs;
    private volatile IFileStorageAppSoap ifsa;
    private volatile ITrackerAppSoap itas;
    private volatile IDocumentAppSoap idas;
    private volatile IScmAppSoap isas;
    private volatile IRbacAppSoap iras;
    private volatile IPlanningAppSoap ipas;

    public CollabNetApp(String url, String username, String password) {
        this(url, username);
        this.sessionId = this.login(password);
    }

    public CollabNetApp(String url, String username, String password, String sessionId) {
        this(url, username);
        this.sessionId = sessionId;
    }

    public CollabNetApp(TeamForgeSetting setting) {
        this(setting.getHost(), setting.getUser(), setting.getPassword());
    }

    public CollabNetApp(String url, String username) {
        this(url);
        this.username = username;
    }

    public CollabNetApp(String url) {
        this.url = url;
        this.icns = this.getICollabNetSoap();
    }

    public static CollabNetApp newInstance() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        Preconditions.checkNotNull((Object)((Object)setting), (Object)"The TeamForge setting is not set.");
        return new CollabNetApp(setting);
    }

    private <T> T createProxy(Class<T> type, String wsdlLoc) {
        String soapURL = this.getServerUrl() + SOAP_SERVICE + wsdlLoc + "?wsdl";
        return type.cast(ClientSoapStubFactory.getSoapStub(type, (String)soapURL));
    }

    public ITrackerAppSoap getTrackerSoap() {
        if (this.itas == null) {
            this.itas = this.createProxy(ITrackerAppSoap.class, "TrackerApp");
        }
        return this.itas;
    }

    public IDocumentAppSoap getDocumentAppSoap() {
        if (this.idas == null) {
            this.idas = this.createProxy(IDocumentAppSoap.class, "DocumentApp");
        }
        return this.idas;
    }

    public IScmAppSoap getScmAppSoap() {
        if (this.isas == null) {
            this.isas = this.createProxy(IScmAppSoap.class, "ScmApp");
        }
        return this.isas;
    }

    public IRbacAppSoap getRbacAppSoap() {
        if (this.iras == null) {
            this.iras = this.createProxy(IRbacAppSoap.class, "RbacApp");
        }
        return this.iras;
    }

    public IFrsAppSoap getFrsAppSoap() {
        if (this.ifrs == null) {
            this.ifrs = this.createProxy(IFrsAppSoap.class, "FrsApp");
        }
        return this.ifrs;
    }

    public IFileStorageAppSoap getFileStorageAppSoap() {
        if (this.ifsa == null) {
            this.ifsa = this.createProxy(IFileStorageAppSoap.class, "FileStorageApp");
        }
        return this.ifsa;
    }

    public IPlanningAppSoap getPlanningAppSoap() {
        if (this.ipas == null) {
            this.ipas = this.createProxy(IPlanningAppSoap.class, "PlanningApp");
        }
        return this.ipas;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getServerUrl() {
        return this.url;
    }

    private ICollabNetSoap getICollabNetSoap() {
        return CollabNetApp.getICollabNetSoap(this.url);
    }

    private static ICollabNetSoap getICollabNetSoap(String url) {
        String soapURL = url + SOAP_SERVICE + "CollabNet?wsdl";
        return (ICollabNetSoap)ClientSoapStubFactory.getSoapStub(ICollabNetSoap.class, (String)soapURL);
    }

    private String login(String password) {
        try {
            this.sessionId = this.icns.login(this.username, password);
        }
        catch (RemoteException e) {
            throw new TrackerException("Login to Teamforge " + this.getServerUrl() + " with user " + this.getUsername() + " failed.", (Throwable)e);
        }
        return this.sessionId;
    }

    public void loginWithToken(String token) {
        try {
            this.sessionId = this.icns.loginWithToken(this.username, token);
        }
        catch (RemoteException e) {
            throw new TrackerException("Login to Teamforge " + this.getServerUrl() + " with user " + this.getUsername() + " failed. ", (Throwable)e);
        }
    }

    public void logoff() {
        this.checkValidSessionId();
        try {
            this.icns.logoff(this.username, this.sessionId);
        }
        catch (RemoteException e) {
            throw new TrackerException("Signing out from Teamforge " + this.getServerUrl() + " failed.", (Throwable)e);
        }
        finally {
            this.sessionId = null;
        }
    }

    public CTFFile upload(DataHandler src) {
        try {
            return new CTFFile(this, this.getFileStorageAppSoap().uploadFile(this.getSessionId(), src));
        }
        catch (RemoteException e) {
            throw new TrackerException("Upload file " + src.getName() + " failed.", (Throwable)e);
        }
    }

    public CTFFile upload(File src) {
        return this.upload(new DataHandler((DataSource)new FileDataSource(src)));
    }

    public static String getApiVersion(String url) {
        try {
            return CollabNetApp.getICollabNetSoap(url).getApiVersion();
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch Teamforge API version from URL " + url + " failed.", (Throwable)e);
        }
    }

    public String getApiVersion() {
        try {
            return this.icns.getApiVersion();
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch Teamforge API version from URL " + this.url + " failed.", (Throwable)e);
        }
    }

    public String getVersion() {
        this.checkValidSessionId();
        try {
            return this.icns.getVersion(this.sessionId);
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch Teamforge API version from URL " + this.url + " failed.", (Throwable)e);
        }
    }

    public boolean isUsernameValid(String username) {
        this.checkValidSessionId();
        return this.getUser(username) != null;
    }

    public CTFList<CTFGroup> getGroups() {
        this.checkValidSessionId();
        CTFList<CTFGroup> r = new CTFList<CTFGroup>();
        try {
            Group2SoapList gsList = this.icns.getGroupList2(this.sessionId, null);
            for (Group2SoapRow row : gsList.getDataRows()) {
                r.add(new CTFGroup(this, row));
            }
            return r;
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch groups failed.", (Throwable)e);
        }
    }

    public CTFGroup getGroupByTitle(String fullName) {
        return this.getGroups().byTitle(fullName);
    }

    public CTFGroup createGroup(String fullName, String description) {
        try {
            return new CTFGroup(this, this.icns.createGroup(this.getSessionId(), fullName, description));
        }
        catch (RemoteException e) {
            throw new TrackerException("Create group " + fullName + " failed.", (Throwable)e);
        }
    }

    public String createProject(String name, String title, String description) {
        try {
            return this.icns.createProject(this.sessionId, name, title, description).getId();
        }
        catch (RemoteException e) {
            throw new TrackerException("Create project " + name + " failed.", (Throwable)e);
        }
    }

    public Collection<String> getGroupUsers(String groupId) throws RemoteException {
        this.checkValidSessionId();
        ArrayList<String> users = new ArrayList<String>();
        UserSoapList usList = this.icns.getActiveGroupMembers(this.sessionId, groupId);
        for (UserSoapRow row : usList.getDataRows()) {
            users.add(row.getUserName());
        }
        return users;
    }

    public void checkValidSessionId() {
        if (this.sessionId == null) {
            throw new TrackerException("Not currently in a valid session.");
        }
    }

    public CTFProject getProjectById(String projectId) {
        try {
            return new CTFProject(this, this.icns.getProjectData(this.sessionId, projectId));
        }
        catch (NoSuchObjectFault e) {
            return null;
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch project " + projectId + " from server " + this.getServerUrl() + " failed.", (Throwable)e);
        }
    }

    public List<CTFProject> getProjects() {
        ArrayList<CTFProject> r = new ArrayList<CTFProject>();
        try {
            for (ProjectSoapRow row : this.icns.getProjectList(this.getSessionId()).getDataRows()) {
                r.add(new CTFProject(this, row));
            }
            return r;
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch projects failed.", (Throwable)e);
        }
    }

    public CTFProject getProjectByTitle(String title) {
        for (CTFProject p : this.getProjects()) {
            if (!p.getTitle().equals(title)) continue;
            return p;
        }
        return null;
    }

    String getTrackerId(String projectId, String tracker) {
        CTFProject project = this.getProjectById(projectId);
        CTFList<CTFTracker> list = project.getTrackers();
        for (CTFTracker each : list) {
            if (!tracker.equalsIgnoreCase(each.getId()) && !tracker.equalsIgnoreCase(each.getTitle())) continue;
            return each.getId();
        }
        return null;
    }

    String getPlanningFolderId(String planningFolder) {
        return null;
    }

    public PlanningFolderSoapDO getPlanningFolder(String planningFolderId) {
        try {
            return this.getPlanningAppSoap().getPlanningFolderData(this.sessionId, planningFolderId);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFList<CTFPackage> getPackages(String projectId) {
        CTFProject project = this.getProjectById(projectId);
        return project.getPackages();
    }

    public CTFIssue createArtifact(String projectId, String tracker, String title, String description, String status, int priority, String assignee, Map<String, String> fields) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)title);
        if (Strings.isNullOrEmpty((String)description)) {
            description = title;
        }
        try {
            CTFProject project = this.getProjectById(projectId);
            CTFTracker t = project.findTracker(tracker);
            if (t == null) {
                throw new TrackerException("No such tracker " + tracker);
            }
            String trackerId = t.getId();
            String group = MapUtils.getString(fields, (Object)"group", null);
            String category = MapUtils.getString(fields, (Object)"category", null);
            String customer = MapUtils.getString(fields, (Object)"customer", null);
            int estimatedEffort = Integer.valueOf(MapUtils.getString(fields, (Object)"estimatedEffort", (String)"0"));
            int remainingEffort = Integer.valueOf(MapUtils.getString(fields, (Object)"remainingEffort", (String)"0"));
            String releaseId = MapUtils.getString(fields, (Object)"releaseId", null);
            boolean autosumming = Boolean.valueOf(MapUtils.getString(fields, (Object)"autosumming", (String)"false"));
            String planningFolderId = MapUtils.getString(fields, (Object)"planningFolder", null);
            Artifact2SoapDO asd = this.getTrackerSoap().createArtifact2(this.getSessionId(), trackerId, title, description, group, category, status, customer, priority, estimatedEffort, remainingEffort, autosumming, assignee, releaseId, planningFolderId, CTFUtils.createFlexFieldValues(fields), null, null, null);
            return new CTFIssue(asd);
        }
        catch (RemoteException e) {
            throw new TrackerException("Create issue failed.", (Throwable)e);
        }
    }

    public CTFIssue getIssue(String issueId) {
        return new CTFIssue(this.getArtifact2Soap(issueId));
    }

    public Artifact2SoapDO getArtifact2Soap(String issueId) {
        try {
            return this.getTrackerSoap().getArtifactData2(this.sessionId, issueId);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public List<CTFIssue> findIssues(String projectId, String queryString) {
        try {
            Artifact2SoapList list = this.getTrackerSoap().findArtifacts2(this.sessionId, queryString, projectId, false);
            ArrayList issues = Lists.newArrayList();
            for (Artifact2SoapRow each : list.getDataRows()) {
                issues.add(new CTFIssue(each));
            }
            return issues;
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void updateIssue(String key, Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Artifact2SoapDO asd = this.getArtifact2Soap(key);
        asd = CTFUtils.updateArtifact2(asd, attributes);
        this.updateIssue(asd, MapUtils.getString(attributes, (Object)"comment"));
    }

    public void updateIssue(ArtifactSoapDO asd, String comment) {
        try {
            this.getTrackerSoap().setArtifactData(this.sessionId, asd, comment, null, null, null);
        }
        catch (RemoteException e) {
            throw new TrackerException("Update artifact " + asd.getId() + " failed.", (Throwable)e);
        }
    }

    public void updateIssue(Artifact2SoapDO asd, String comment) {
        try {
            this.getTrackerSoap().setArtifactData2(this.sessionId, asd, comment, null, null, null);
        }
        catch (RemoteException e) {
            throw new TrackerException("Update artifact " + asd.getId() + " failed.", (Throwable)e);
        }
    }

    public ReleaseSoapDO createRelease(String packageId, String title, String description, String status, String maturity) {
        try {
            return this.getFrsAppSoap().createRelease(this.sessionId, packageId, title, description, status, maturity);
        }
        catch (RemoteException e) {
            throw new TrackerException("Create release " + title + " to package " + packageId + " failed.", (Throwable)e);
        }
    }

    public CTFUser getMyself() {
        return this.getUser(this.username);
    }

    public CTFUser getUser(String username) {
        try {
            return new CTFUser(this, this.icns.getUserData(this.getSessionId(), username));
        }
        catch (NoSuchObjectFault e) {
            return null;
        }
        catch (AxisFault e) {
            if (NoSuchObjectFault.FAULT_CODE.equals(e.getFaultCode())) {
                return null;
            }
            throw new TrackerException("Fetch user " + username + " from Teamforge " + this.getServerUrl() + " failed.", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new TrackerException("Fetch user " + username + " from Teamforge " + this.getServerUrl() + " failed.", (Throwable)e);
        }
    }

    public CTFUser createUser(String username, String email, String fullName, String locale, String timeZone, boolean isSuperUser, boolean isRestrictedUser, String password) {
        try {
            return new CTFUser(this, this.icns.createUser(this.getSessionId(), username, email, fullName, locale, timeZone, isSuperUser, isRestrictedUser, password));
        }
        catch (RemoteException e) {
            throw new TrackerException("Unable to create user " + username, (Throwable)e);
        }
    }

    public static void closeQuietly(CollabNetApp app) {
        if (app == null) {
            return;
        }
        app.logoff();
    }
}

