/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.webservices.cemain.GroupSoapList;
import com.collabnet.ce.soap50.webservices.cemain.GroupSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.ProjectMemberSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapDO;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFGroup;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.ObjectWithTitle;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;

public class CTFUser
extends CTFObject
implements ObjectWithTitle {
    private static final long serialVersionUID = 1L;
    private String userName;
    private String fullName;
    private String email;
    private volatile UserSoapDO data;

    CTFUser(CollabNetApp app, ProjectMemberSoapRow data) {
        super(app, data.getUserName());
        this.userName = data.getUserName();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
    }

    CTFUser(CollabNetApp app, UserSoapDO data) {
        super(app, data.getUsername());
        this.userName = data.getUsername();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
        this.data = data;
    }

    CTFUser(CollabNetApp app, UserSoapRow data) {
        super(app, data.getUserName());
        this.userName = data.getUserName();
        this.fullName = data.getFullName();
        this.email = data.getEmail();
    }

    private UserSoapDO data() {
        try {
            if (this.data == null) {
                this.data = this.app.icns.getUserData(this.app.getSessionId(), this.getId());
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return this.data;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String getTitle() {
        return this.userName;
    }

    public String getLocale() {
        return this.data().getLocale();
    }

    public String getTimeZone() {
        return this.data().getTimeZone();
    }

    public boolean isSuperUser() {
        return this.data().getSuperUser();
    }

    public boolean isRestrictedUser() {
        return this.data().getRestrictedUser();
    }

    public String getStatus() {
        return this.data().getStatus();
    }

    public Set<String> getGroupNames() {
        GroupSoapList gList;
        HashSet<String> groups = new HashSet<String>();
        try {
            gList = this.app.icns.getUserGroupList(this.app.getSessionId(), this.userName);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        for (GroupSoapRow row : gList.getDataRows()) {
            groups.add(row.getFullName());
        }
        return groups;
    }

    public CTFList<CTFGroup> getGroups() {
        GroupSoapList gList;
        CTFList<CTFGroup> groups = new CTFList<CTFGroup>();
        try {
            gList = this.app.icns.getUserGroupList(this.app.getSessionId(), this.userName);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        for (GroupSoapRow row : gList.getDataRows()) {
            groups.add(this.app.getGroupByTitle(row.getFullName()));
        }
        return groups;
    }

    public void addTo(CTFGroup g) {
        g.addMember(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CTFUser that = (CTFUser)o;
        return this.userName.equals(that.userName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }
}

