/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.types.SoapFieldValues;
import com.collabnet.ce.soap50.types.SoapFilter;
import com.collabnet.ce.soap50.webservices.cemain.FolderSoapDO;
import com.collabnet.ce.soap50.webservices.cemain.FolderSoapRow;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapRow;
import com.collabnet.ce.soap50.webservices.tracker.Tracker2SoapDO;
import com.collabnet.ce.soap50.webservices.tracker.Tracker2SoapRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFArtifact;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFolder;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CTFTracker
extends CTFFolder {
    private static final long serialVersionUID = 1L;
    private final CTFProject project;
    private final String icon;

    public CTFTracker(CTFProject parent, Tracker2SoapRow data) {
        super((CTFObject)parent, (FolderSoapRow)data);
        this.project = parent;
        this.icon = data.getIcon();
    }

    public CTFTracker(CTFProject parent, Tracker2SoapDO data) {
        super((CTFObject)parent, (FolderSoapDO)data);
        this.project = parent;
        this.icon = data.getIcon();
    }

    @Override
    public CTFProject getProject() {
        return this.project;
    }

    public List<CTFArtifact> getArtifactsByTitle(String title) {
        SoapFilter[] filters = new SoapFilter[]{new SoapFilter("title", title)};
        ArrayList<CTFArtifact> r = new ArrayList<CTFArtifact>();
        try {
            for (ArtifactSoapRow row : this.app.getTrackerSoap().getArtifactList(this.app.getSessionId(), this.getId(), filters).getDataRows()) {
                r.add(new CTFArtifact((CTFObject)this, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public CTFArtifact createArtifact(String title, String description, String group, String category, String status, String customer, int priority, int estimatedHours, String assignTo, String releaseId, SoapFieldValues flexFields, String fileName, String fileMimeType, CTFFile file) {
        try {
            return new CTFArtifact((CTFObject)this, this.app.getTrackerSoap().createArtifact(this.app.getSessionId(), this.getId(), title, description, group, category, status, customer, priority, estimatedHours, assignTo, releaseId, flexFields, fileName, fileMimeType, file != null ? file.getId() : null));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public String getIcon() {
        return this.icon;
    }
}

