/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapDO;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFProject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFUser;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.ObjectWithTitle;
import java.rmi.RemoteException;

public class CTFRole
extends CTFObject
implements ObjectWithTitle {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String description;

    public CTFRole(CTFProject parent, RoleSoapDO data) {
        super(parent, data.getId());
        this.title = data.getTitle();
        this.description = data.getDescription();
    }

    public CTFRole(CTFProject parent, RoleSoapRow data) {
        super(parent, data.getId());
        this.title = data.getTitle();
        this.description = data.getDescription();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public CTFList<CTFUser> getMembers() {
        CTFList<CTFUser> r = new CTFList<CTFUser>();
        try {
            for (UserSoapRow row : this.app.getRbacAppSoap().getRoleMemberList(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFUser(this.app, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public void grant(String username) {
        try {
            this.app.getRbacAppSoap().addUser(this.app.getSessionId(), this.getId(), username);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void grant(CTFUser u) {
        this.grant(u.getUserName());
    }
}

