/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.webservices.cemain.ItemSoapDO;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapDO;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFItem;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import java.rmi.RemoteException;

public class CTFReleaseFile
extends CTFItem {
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String mimeType;
    private final String filename;
    private final long size;

    protected CTFReleaseFile(CTFObject parent, FrsFileSoapDO data) {
        super(parent, (ItemSoapDO)data);
        this.description = data.getDescription();
        this.mimeType = data.getMimeType();
        this.filename = data.getFilename();
        this.size = data.getSize();
    }

    protected CTFReleaseFile(CTFObject parent, FrsFileSoapRow data) {
        super(parent, CTFReleaseFile.toItemSoapDO(data));
        this.description = data.getDescription();
        this.mimeType = data.getMimeType();
        this.filename = data.getFilename();
        this.size = data.getFileSize();
    }

    private static ItemSoapDO toItemSoapDO(FrsFileSoapRow data) {
        ItemSoapDO r = new ItemSoapDO();
        r.setTitle(data.getTitle());
        r.setId(data.getId());
        return r;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public String getURL() {
        return this.app.getServerUrl() + "/sf/frs/do/downloadFile/" + this.getPath();
    }

    public void delete() {
        try {
            this.app.getFrsAppSoap().deleteFrsFile(this.app.getSessionId(), this.getId());
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }
}

