/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.webservices.cemain.FolderSoapDO;
import com.collabnet.ce.soap50.webservices.cemain.FolderSoapRow;
import com.collabnet.ce.soap50.webservices.frs.FrsFileSoapRow;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapDO;
import com.collabnet.ce.soap50.webservices.frs.ReleaseSoapRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFolder;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFPackage;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFReleaseFile;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CTFRelease
extends CTFFolder {
    private static final long serialVersionUID = 1L;

    CTFRelease(CTFPackage parent, ReleaseSoapDO data) {
        super((CTFObject)parent, (FolderSoapDO)data);
    }

    CTFRelease(CTFPackage parent, ReleaseSoapRow data) {
        super((CTFObject)parent, (FolderSoapRow)data);
    }

    public String getUrl() {
        return this.app.getServerUrl() + "/sf/frs/do/viewRelease/" + this.getPath();
    }

    public void delete() {
        try {
            this.app.getFrsAppSoap().deleteRelease(this.app.getSessionId(), this.getId());
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFReleaseFile getFileByTitle(String title) {
        for (CTFReleaseFile f : this.getFiles()) {
            if (!f.getTitle().equals(title)) continue;
            return f;
        }
        return null;
    }

    public List<CTFReleaseFile> getFiles() {
        ArrayList<CTFReleaseFile> r = new ArrayList<CTFReleaseFile>();
        try {
            for (FrsFileSoapRow row : this.app.getFrsAppSoap().getFrsFileList(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFReleaseFile((CTFObject)this, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public CTFReleaseFile addFile(String fileName, String mimeType, CTFFile file) {
        try {
            return new CTFReleaseFile((CTFObject)this, this.app.getFrsAppSoap().createFrsFile(this.app.getSessionId(), this.getId(), fileName, mimeType, file.getId()));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }
}

