/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.fault.NoSuchObjectFault;
import com.collabnet.ce.soap50.webservices.cemain.ProjectMemberSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.ProjectSoapDO;
import com.collabnet.ce.soap50.webservices.cemain.ProjectSoapRow;
import com.collabnet.ce.soap50.webservices.cemain.UserSoapRow;
import com.collabnet.ce.soap50.webservices.docman.DocumentFolderSoapList;
import com.collabnet.ce.soap50.webservices.docman.DocumentFolderSoapRow;
import com.collabnet.ce.soap50.webservices.frs.PackageSoapRow;
import com.collabnet.ce.soap50.webservices.planning.PlanningFolderSoapList;
import com.collabnet.ce.soap50.webservices.planning.PlanningFolderSoapRow;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapList;
import com.collabnet.ce.soap50.webservices.rbac.RoleSoapRow;
import com.collabnet.ce.soap50.webservices.scm.RepositorySoapRow;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.soap50.webservices.tracker.Tracker2SoapRow;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFDocumentFolder;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFList;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFPackage;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFPlanningFolder;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFRole;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFScmRepository;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFUser;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.ObjectWithTitle;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CTFProject
extends CTFObject
implements ObjectWithTitle {
    private static final long serialVersionUID = 1L;
    private final String title;

    CTFProject(CollabNetApp app, ProjectSoapDO data) {
        super(app, data.getId());
        this.title = data.getTitle();
    }

    CTFProject(CollabNetApp app, ProjectSoapRow data) {
        super(app, data.getId());
        this.title = data.getTitle();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public CTFPackage createPackage(String title, String description, boolean isPublished) {
        try {
            return new CTFPackage((CTFObject)this, this.app.getFrsAppSoap().createPackage(this.app.getSessionId(), this.getId(), title, description, isPublished));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFList<CTFPackage> getPackages() {
        CTFList<CTFPackage> r = new CTFList<CTFPackage>();
        try {
            for (PackageSoapRow row : this.app.getFrsAppSoap().getPackageList(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFPackage((CTFObject)this, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public CTFList<CTFTracker> getTrackers() {
        CTFList<CTFTracker> r = new CTFList<CTFTracker>();
        try {
            for (Tracker2SoapRow row : this.app.getTrackerSoap().getTracker2List(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFTracker(this, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public CTFTracker findTracker(String nameOrId) {
        CTFList<CTFTracker> list = this.getTrackers();
        CTFTracker t = list.byId(nameOrId);
        if (t != null) {
            return t;
        }
        return list.byTitle(nameOrId);
    }

    public List<String> getTrackerNames() {
        CTFList<CTFTracker> trackers = this.getTrackers();
        ArrayList names = Lists.newArrayList();
        for (CTFTracker each : trackers) {
            names.add(each.getTitle());
        }
        return names;
    }

    public CTFTracker createTracker(String name, String title, String description) {
        try {
            return new CTFTracker(this, this.app.getTrackerSoap().createTracker2(this.app.getSessionId(), this.getId(), name, title, description, null));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFList<CTFScmRepository> getScmRepositories() {
        CTFList<CTFScmRepository> r = new CTFList<CTFScmRepository>();
        try {
            for (RepositorySoapRow row : this.app.getScmAppSoap().getRepositoryList(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFScmRepository(this, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public List<CTFUser> getMembers() {
        ArrayList<CTFUser> r = new ArrayList<CTFUser>();
        try {
            for (ProjectMemberSoapRow row : this.app.icns.getProjectMemberList(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFUser(this.app, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public ArtifactSoapDO getArtifact(String artifactId) {
        try {
            return this.app.getTrackerSoap().getArtifactData(this.app.getSessionId(), artifactId);
        }
        catch (NoSuchObjectFault e) {
            return null;
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public List<CTFUser> getAdmins() {
        ArrayList<CTFUser> r = new ArrayList<CTFUser>();
        try {
            for (UserSoapRow row : this.app.icns.listProjectAdmins(this.app.getSessionId(), this.getId()).getDataRows()) {
                r.add(new CTFUser(this.app, row));
            }
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
        return r;
    }

    public void addMember(String userName) {
        try {
            this.app.icns.addProjectMember(this.app.getSessionId(), this.getId(), userName);
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public void addMember(CTFUser u) {
        this.addMember(u.getUserName());
    }

    public boolean hasMember(String username) {
        for (CTFUser u : this.getMembers()) {
            if (!u.getUserName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public CTFList<CTFRole> getRoles() {
        try {
            return this.toRoleList(this.app.getRbacAppSoap().getRoleList(this.app.getSessionId(), this.getId()));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFRole createRole(String title, String description) {
        try {
            return new CTFRole(this, this.app.getRbacAppSoap().createRole(this.app.getSessionId(), this.getId(), title, description));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFList<CTFRole> getUserRoles(CTFUser u) {
        return this.getUserRoles(u.getUserName());
    }

    public CTFList<CTFRole> getUserRoles(String username) {
        try {
            return this.toRoleList(this.app.getRbacAppSoap().getUserRoleList(this.app.getSessionId(), this.getId(), username));
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    private CTFList<CTFRole> toRoleList(RoleSoapList roles) {
        CTFList<CTFRole> r = new CTFList<CTFRole>();
        for (RoleSoapRow row : roles.getDataRows()) {
            r.add(new CTFRole(this, row));
        }
        return r;
    }

    public CTFDocumentFolder getRootFolder() {
        try {
            DocumentFolderSoapList dfsList = this.app.getDocumentAppSoap().getDocumentFolderList(this.app.getSessionId(), this.getId(), false);
            switch (dfsList.getDataRows().length) {
                case 0: {
                    throw new TrackerException("getRootFolder for projectId " + this.title + " failed to find any folders");
                }
                case 1: {
                    return new CTFDocumentFolder((CTFObject)this, dfsList.getDataRows()[0]);
                }
            }
            StringBuilder rowNames = new StringBuilder();
            for (DocumentFolderSoapRow row : dfsList.getDataRows()) {
                rowNames.append(row.getTitle() + ", ");
            }
            throw new TrackerException("getRootFolder returned unexpected number of folders: " + rowNames.toString());
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public CTFDocumentFolder getOrCreateDocumentFolder(String documentPath) {
        CTFDocumentFolder next;
        String[] folderNames = documentPath.split("/");
        int i = 0;
        CTFDocumentFolder cur = this.getRootFolder();
        if (cur.getTitle().equals(folderNames[i])) {
            ++i;
        }
        while (i < folderNames.length && (next = cur.getFolders().byTitle(folderNames[i])) != null) {
            cur = next;
            ++i;
        }
        while (i < folderNames.length) {
            cur = cur.createFolder(folderNames[i], folderNames[i]);
            ++i;
        }
        return cur;
    }

    public String verifyPath(String documentPath) {
        String[] folderNames = documentPath.split("/");
        int i = 0;
        CTFDocumentFolder cur = this.getRootFolder();
        if (cur.getTitle().equals(folderNames[i])) {
            ++i;
        }
        while (i < folderNames.length) {
            CTFDocumentFolder next = cur.getFolders().byTitle(folderNames[i]);
            if (next == null) {
                return folderNames[i];
            }
            cur = next;
            ++i;
        }
        return null;
    }

    public CTFList<CTFPlanningFolder> getPlanningFolderList(boolean recursive) {
        return this.getPlanningFolderList(null, recursive);
    }

    public CTFList<CTFPlanningFolder> getPlanningFolderList(String parentId, boolean recursive) {
        String id = Strings.isNullOrEmpty((String)parentId) ? this.getId() : parentId;
        try {
            PlanningFolderSoapList list = this.app.getPlanningAppSoap().getPlanningFolderList(this.app.getSessionId(), id, recursive);
            CTFList<CTFPlanningFolder> folders = new CTFList<CTFPlanningFolder>();
            for (PlanningFolderSoapRow each : list.getDataRows()) {
                folders.add(new CTFPlanningFolder((CTFObject)this, each));
            }
            return folders;
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }
}

