/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.webservices.cemain.ItemSoapDO;
import com.collabnet.ce.soap50.webservices.docman.DocumentSoapDO;
import com.collabnet.ce.soap50.webservices.docman.DocumentSoapRow;
import com.collabnet.ce.soap50.webservices.docman.IDocumentAppSoap;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFItem;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import java.rmi.RemoteException;

public class CTFDocument
extends CTFItem {
    private static final long serialVersionUID = 1L;
    private final String description;

    public CTFDocument(CTFObject parent, DocumentSoapRow data) {
        super(parent, CTFDocument.toItemSoapDO(data));
        this.description = data.getDescription();
    }

    public CTFDocument(CTFObject parent, DocumentSoapDO data) {
        super(parent, (ItemSoapDO)data);
        this.description = data.getDescription();
    }

    private static ItemSoapDO toItemSoapDO(DocumentSoapRow data) {
        ItemSoapDO r = new ItemSoapDO();
        r.setTitle(data.getTitle());
        r.setId(data.getId());
        return r;
    }

    public String getDescription() {
        return this.description;
    }

    public void update(CTFFile file) {
        IDocumentAppSoap soap = this.app.getDocumentAppSoap();
        try {
            DocumentSoapDO docData = soap.getDocumentData(this.app.getSessionId(), this.getId(), 0);
            docData.setCurrentVersion(docData.getLatestVersion() + 1);
            soap.setDocumentData(this.app.getSessionId(), docData, file.getId());
        }
        catch (RemoteException e) {
            throw new TrackerException((Throwable)e);
        }
    }

    public String getURL() {
        return this.app.getServerUrl() + "/sf/go/" + this.getId();
    }
}

