/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge.client;

import com.collabnet.ce.soap50.types.SoapFieldValues;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapDO;
import com.collabnet.ce.soap50.webservices.tracker.ArtifactSoapRow;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFFile;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFObject;
import java.rmi.RemoteException;
import java.util.Date;

public class CTFArtifact
extends CTFObject {
    private ArtifactSoapDO data;
    private boolean needsRefill;

    CTFArtifact(CTFObject parent, ArtifactSoapRow src) {
        super(parent, src.getId());
        this.needsRefill = true;
        this.data = new ArtifactSoapDO();
        this.data.setActualHours(src.getActualHours());
        this.data.setAssignedTo(src.getAssignedToUsername());
        this.data.setCategory(src.getCategory());
        this.data.setCloseDate(src.getCloseDate());
        this.data.setCreatedBy(src.getSubmittedByUsername());
        this.data.setCreatedDate(src.getSubmittedDate());
        this.data.setCustomer(src.getCustomer());
        this.data.setDescription(src.getDescription());
        this.data.setEstimatedHours(src.getEstimatedHours());
        this.data.setFolderId(src.getFolderId());
        this.data.setGroup(src.getArtifactGroup());
        this.data.setId(src.getId());
        this.data.setLastModifiedDate(src.getLastModifiedDate());
        this.data.setPriority(src.getPriority());
        this.data.setStatus(src.getStatus());
        this.data.setStatusClass(src.getStatusClass());
    }

    CTFArtifact(CTFObject parent, ArtifactSoapDO data) {
        super(parent, data.getId());
        this.data = data;
    }

    public void refill() throws RemoteException {
        this.data = this.app.getTrackerSoap().getArtifactData(this.app.getSessionId(), this.getId());
        this.needsRefill = false;
    }

    public String getURL() {
        return this.app.getServerUrl() + "/sf/go/" + this.getId();
    }

    public void update(String comment) throws RemoteException {
        this.update(comment, null, null, null);
    }

    public void update(String comment, String fileName, String fileMimeType, CTFFile file) throws RemoteException {
        if (this.needsRefill) {
            throw new IllegalStateException("CTFArtifact needs to be filled before it can be updated");
        }
        this.app.getTrackerSoap().setArtifactData(this.app.getSessionId(), this.data, comment, fileName, fileMimeType, file != null ? file.getId() : null);
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.data.setDescription(description);
    }

    public String getCategory() {
        return this.data.getCategory();
    }

    public void setCategory(String category) {
        this.data.setCategory(category);
    }

    public String getGroup() {
        return this.data.getGroup();
    }

    public void setGroup(String group) {
        this.data.setGroup(group);
    }

    public String getStatus() {
        return this.data.getStatus();
    }

    public void setStatus(String status) {
        this.data.setStatus(status);
    }

    public String getStatusClass() {
        return this.data.getStatusClass();
    }

    public void setStatusClass(String statusClass) {
        this.data.setStatusClass(statusClass);
    }

    public String getCustomer() {
        return this.data.getCustomer();
    }

    public void setCustomer(String customer) {
        this.data.setCustomer(customer);
    }

    public int getPriority() {
        return this.data.getPriority();
    }

    public void setPriority(int priority) {
        this.data.setPriority(priority);
    }

    public int getEstimatedHours() {
        return this.data.getEstimatedHours();
    }

    public void setEstimatedHours(int estimatedHours) {
        this.data.setEstimatedHours(estimatedHours);
    }

    public int getActualHours() {
        return this.data.getActualHours();
    }

    public void setActualHours(int actualHours) {
        this.data.setActualHours(actualHours);
    }

    public Date getCloseDate() {
        return this.data.getCloseDate();
    }

    public void setCloseDate(Date closeDate) {
        this.data.setCloseDate(closeDate);
    }

    public String getAssignedTo() {
        return this.data.getAssignedTo();
    }

    public void setAssignedTo(String assignedTo) {
        this.data.setAssignedTo(assignedTo);
    }

    public String getReportedReleaseId() {
        return this.data.getReportedReleaseId();
    }

    public void setReportedReleaseId(String reportedReleaseId) {
        this.data.setReportedReleaseId(reportedReleaseId);
    }

    public String getResolvedReleaseId() {
        return this.data.getResolvedReleaseId();
    }

    public void setResolvedReleaseId(String resolvedReleaseId) {
        this.data.setResolvedReleaseId(resolvedReleaseId);
    }

    public SoapFieldValues getFlexFields() {
        return this.data.getFlexFields();
    }

    public void setFlexFields(SoapFieldValues flexFields) {
        this.data.setFlexFields(flexFields);
    }

    public String getPath() {
        return this.data.getPath();
    }

    public String getTitle() {
        return this.data.getTitle();
    }

    public void setTitle(String title) {
        this.data.setTitle(title);
    }

    public String getFolderId() {
        return this.data.getFolderId();
    }

    public void setFolderId(String folderId) {
        this.data.setFolderId(folderId);
    }

    public int getVersion() {
        return this.data.getVersion();
    }

    public String getCreatedBy() {
        return this.data.getCreatedBy();
    }

    public String getLastModifiedBy() {
        return this.data.getLastModifiedBy();
    }

    public Date getCreatedDate() {
        return this.data.getCreatedDate();
    }

    public Date getLastModifiedDate() {
        return this.data.getLastModifiedDate();
    }
}

