/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFPlugin;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFIssue;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class TeamForgeTracker
extends AbstractIssueTracker {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Issue> fetchIssues(Collection<String> keys) {
        CollabNetApp app = CollabNetApp.newInstance();
        try {
            LinkedHashMap issues = Maps.newLinkedHashMap();
            for (String each : keys) {
                CTFIssue issue = app.getIssue(each);
                issues.put(each, issue);
            }
            LinkedHashMap linkedHashMap = issues;
            return linkedHashMap;
        }
        finally {
            CollabNetApp.closeQuietly(app);
        }
    }

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        return CTFPlugin.class;
    }

    public String getIssueUrlPattern() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        Preconditions.checkNotNull((Object)((Object)setting));
        return StringHelper.normalizeUrl((String)setting.getHost()) + "/sf/go/$KEY";
    }
}

