/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge;

import com.pmease.quickbuild.extensionpoint.AuthenticatorProvider;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFAuthenticator;
import com.pmease.quickbuild.plugin.tracker.teamforge.CTFRestResource;
import com.pmease.quickbuild.plugin.tracker.teamforge.TeamForgeCategory;
import com.pmease.quickbuild.plugin.tracker.teamforge.TeamForgeTracker;
import com.pmease.quickbuild.plugin.tracker.teamforge.gadget.TeamForgeGadget;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.setting.TeamForgeUserSetting;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.CreateArtifactStep;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.CreateReleaseStep;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.UpdateArtifactStep;
import com.pmease.quickbuild.plugin.tracker.teamforge.step.UploadFilesStep;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.stepsupport.Step;

public class CTFPlugin
extends AbstractTrackerPlugin {
    public IssueTracker createTracker() {
        return new TeamForgeTracker();
    }

    protected Class<?>[] getRestResourceClasses() {
        return new Class[]{CTFRestResource.class};
    }

    protected IssueCategory createCategory() {
        return new TeamForgeCategory();
    }

    public Class<?> getConfigurationSettingClass() {
        return TeamForgeSetting.class;
    }

    public Class<?> getUserSettingClass() {
        return TeamForgeUserSetting.class;
    }

    private static boolean isApplicable() {
        TeamForgeSetting setting = TeamForgeSetting.get();
        return setting != null;
    }

    protected Class<? extends Gadget>[] getGadgetClasses() {
        return new Class[]{TeamForgeGadget.class};
    }

    protected Object[] getExtraExtensions() {
        return new Object[]{new AuthenticatorProvider(){

            public Class<? extends Authenticator> getAuthenticatorClass() {
                return CTFAuthenticator.class;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (CTFPlugin.isApplicable()) {
                    return CreateArtifactStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (CTFPlugin.isApplicable()) {
                    return UpdateArtifactStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (CTFPlugin.isApplicable()) {
                    return CreateReleaseStep.class;
                }
                return null;
            }
        }, new StepProvider(){

            public Class<? extends Step> getStepClass() {
                if (CTFPlugin.isApplicable()) {
                    return UploadFilesStep.class;
                }
                return null;
            }
        }};
    }
}

