/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.teamforge;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CTFUser;
import com.pmease.quickbuild.plugin.tracker.teamforge.client.CollabNetApp;
import com.pmease.quickbuild.security.AuthenticationResult;
import com.pmease.quickbuild.security.Authenticator;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="TeamForge")
public class CTFAuthenticator
extends Authenticator {
    private static final long serialVersionUID = 1L;
    private String url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(String userName, String password) {
        AuthenticationResult authenticationResult;
        if (password == null) {
            return null;
        }
        CollabNetApp app = null;
        try {
            app = new CollabNetApp(this.getUrl(), userName, password);
            AuthenticationResult result = new AuthenticationResult();
            CTFUser user = app.getMyself();
            if (user == null) {
                AuthenticationResult authenticationResult2 = null;
                CollabNetApp.closeQuietly(app);
                return authenticationResult2;
            }
            result.setFullName(user.getFullName());
            result.setEmail(user.getEmail());
            result.setGroupNames(user.getGroupNames());
            authenticationResult = result;
            CollabNetApp.closeQuietly(app);
        }
        catch (TrackerException e) {
            AuthenticationResult authenticationResult3 = null;
            return authenticationResult3;
        }
        finally {
            CollabNetApp.closeQuietly(app);
        }
        return authenticationResult;
    }

    @Editable(name="TeamForge URL", order=100, description="Specifies the TeamForge URL")
    @NotEmpty
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

