/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Strings;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractWorkspacesConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.WorkingFolder;
import com.pmease.quickbuild.plugin.scm.tfs.Workspace;
import com.pmease.quickbuild.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WorkspacesConsumer
extends AbstractWorkspacesConsumer {
    public WorkspacesConsumer() {
        super(Log.LogLevel.DEBUG, null);
    }

    @Override
    public boolean hasWorkspace(Workspace expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Expected workspace should not be null");
        }
        ArrayList<String> block = new ArrayList<String>();
        for (String line : this.lines) {
            if (line.startsWith("==========")) {
                Workspace workspace = this.parseWorkspace(block);
                if (expected.equals(workspace)) {
                    return true;
                }
                block = new ArrayList();
                continue;
            }
            block.add(line);
        }
        Workspace workspace = this.parseWorkspace(block);
        return expected.equals(workspace);
    }

    @Override
    public List<Workspace> getWorkspaces() {
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        ArrayList<String> block = new ArrayList<String>();
        for (String line : this.lines) {
            if (line.startsWith("==========")) {
                Workspace workspace = this.parseWorkspace(block);
                if (workspace != null) {
                    workspaces.add(workspace);
                }
                block = new ArrayList();
                continue;
            }
            block.add(line);
        }
        Workspace workspace = this.parseWorkspace(block);
        if (workspace != null) {
            workspaces.add(workspace);
        }
        return workspaces;
    }

    private Workspace parseWorkspace(List<String> block) {
        if (block.isEmpty() || block.size() < 7) {
            return null;
        }
        Workspace workspace = new Workspace();
        workspace.setName((String)WorkspacesConsumer.split(block.get(0)).getSecond());
        workspace.setOwner((String)WorkspacesConsumer.split(block.get(1)).getSecond());
        workspace.setServer((String)WorkspacesConsumer.split(block.get(4)).getSecond());
        boolean isFolder = false;
        for (int i = 5; i < block.size(); ++i) {
            WorkingFolder folder;
            String line = block.get(i);
            if (Strings.isNullOrEmpty((String)line)) continue;
            if (!isFolder) {
                int pos = line.indexOf(58);
                if (pos <= 0 || pos != line.length() - 1) continue;
                isFolder = true;
                continue;
            }
            if (!Character.isWhitespace(line.charAt(0)) || (folder = WorkingFolder.fromString(line)) == null) continue;
            workspace.addFolder(folder);
        }
        return workspace;
    }

    private static Pair<String, String> split(String line) {
        Pair result = new Pair();
        if (StringUtils.isBlank((String)line)) {
            return result;
        }
        int pos = line.indexOf(58);
        if (pos > 0) {
            result.setFirst((Object)line.substring(0, pos).trim());
            result.setSecond((Object)line.substring(pos + 1).trim());
        }
        return result;
    }
}

