/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRepository;
import com.pmease.quickbuild.plugin.scm.tfs.WorkingFolder;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Workspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String server;
    private String owner;
    private Map<String, WorkingFolder> folders = Maps.newLinkedHashMap();

    public Workspace() {
    }

    public Workspace(TfsRepository repository) {
        this.setName(repository.getWorkspaceName());
        this.setServer(StringUtils.stripEnd((String)repository.getServerUrl(), (String)"/"));
        this.setOwner(repository.getUsername());
        List<WorkingFolder> folders = repository.getEvaluatedFolders();
        for (WorkingFolder each : folders) {
            this.addFolder(each);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void addFolder(WorkingFolder folder) {
        this.folders.put(folder.getServerPath(), folder);
    }

    public Collection<WorkingFolder> getFolders() {
        return ImmutableList.copyOf(this.folders.values());
    }

    public boolean hasLocalFolder(String localFolder) {
        for (WorkingFolder each : this.folders.values()) {
            if (!each.isMapped(localFolder)) continue;
            return true;
        }
        return false;
    }

    private static String formatOwner(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        if (str.contains("@")) {
            return str;
        }
        int pos = str.indexOf(92);
        if (pos > 0) {
            String computer = str.substring(0, pos);
            String user = str.substring(pos + 1);
            return user + '@' + computer;
        }
        return str;
    }

    public boolean equals(Object other) {
        boolean b;
        if (other == null || !(other instanceof Workspace)) {
            return false;
        }
        Workspace rhs = (Workspace)other;
        boolean bl = b = Objects.equal((Object)this.name.toLowerCase(), (Object)rhs.name.toLowerCase()) && Objects.equal((Object)StringUtils.stripEnd((String)this.server, (String)"/").toLowerCase(), (Object)StringUtils.stripEnd((String)rhs.server, (String)"/").toLowerCase()) && Objects.equal((Object)Workspace.formatOwner(this.owner).toLowerCase(), (Object)Workspace.formatOwner(rhs.owner).toLowerCase()) && Objects.equal((Object)this.folders.size(), (Object)rhs.folders.size());
        if (!b) {
            return false;
        }
        for (String each : this.folders.keySet()) {
            WorkingFolder rFolder = rhs.folders.get(each);
            if (Objects.equal((Object)this.folders.get(each), (Object)rFolder)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.server, this.owner, this.folders});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.name).append(", ").append(this.server);
        sb.append("\nOwner: ").append(this.owner);
        sb.append("\nWorking Folder:\n");
        sb.append("-------------------------------------------------------------\n");
        for (WorkingFolder folder : this.folders.values()) {
            sb.append(folder).append("\n");
        }
        return sb.toString();
    }
}

