/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Objects;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.util.FileUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

public class WorkingFolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serverPath;
    private String localPath;
    private String status = "Active";

    @Editable(name="Status", order=100)
    @NotEmpty
    @Choices(value={"Active", "Cloaked"})
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Status getFolderStatus() {
        return Status.valueOf(this.getStatus());
    }

    public boolean isCloaked() {
        return this.getFolderStatus() == Status.Cloaked;
    }

    @Editable(name="Source Control Folder", order=200)
    @NotEmpty
    @Scriptable
    public String getServerPath() {
        return this.serverPath;
    }

    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
    }

    @Editable(name="Local Path", order=300, description="Specifies the local folder to which the contents under source control folder will be retrieved into. This path is relative to the dest path defined previously. If left empty, the dest path itself will be used. Please note that for cloaked folders, this field does not need to be specified.")
    @Scriptable
    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public boolean isMapped(String path) {
        if (StringUtils.isEmpty((String)this.getLocalPath())) {
            return false;
        }
        return FileUtils.getRelativePath((String)path, (String)this.getLocalPath()) != null || FileUtils.getRelativePath((String)this.getLocalPath(), (String)path) != null;
    }

    public static WorkingFolder fromString(String line) {
        int pos;
        boolean cloaked = false;
        if (StringUtils.isEmpty((String)(line = line.trim()))) {
            return null;
        }
        if (line.startsWith("(")) {
            cloaked = true;
            pos = line.indexOf(41);
            line = line.substring(pos + 1).trim();
        }
        if ((pos = line.indexOf(58)) <= 0) {
            return null;
        }
        WorkingFolder folder = new WorkingFolder();
        folder.setServerPath(line.substring(0, pos).trim());
        folder.setLocalPath(line.substring(pos + 1).trim());
        if (cloaked) {
            folder.setStatus(Status.Cloaked.name());
        } else {
            folder.setStatus(Status.Active.name());
        }
        return folder;
    }

    public boolean isRootFolder() {
        return this.getServerPath().equals("$/") || this.getServerPath().equals("$");
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof WorkingFolder)) {
            return false;
        }
        WorkingFolder rhs = (WorkingFolder)other;
        String path1 = this.getLocalPath();
        String path2 = rhs.getLocalPath();
        if (path1 == null) {
            path1 = "";
        }
        if (path2 == null) {
            path2 = "";
        }
        return Objects.equal((Object)this.getServerPath().toLowerCase(), (Object)rhs.getServerPath().toLowerCase()) && Objects.equal((Object)path1.toLowerCase(), (Object)path2.toLowerCase()) && Objects.equal((Object)this.getStatus().toLowerCase(), (Object)rhs.getStatus().toLowerCase());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getServerPath(), this.getLocalPath(), this.getStatus()});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(').append(this.getStatus()).append(")\t").append(this.getServerPath()).append(":  ");
        if (!StringUtils.isEmpty((String)this.getLocalPath())) {
            sb.append(this.getLocalPath());
        }
        return sb.toString();
    }

    public static enum Status {
        Active,
        Cloaked;

    }
}

