/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.scm.tfs.TfsCli;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRepository;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TfsSourceViewSupport
extends SourceViewSupport<TfsRevision> {
    private static final long serialVersionUID = 1L;

    public TfsSourceViewSupport(TfsRepository repository) {
        super((Repository)repository);
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            String checkoutFileCanonicalPath = checkoutFile.getCanonicalPath();
            String destDirCanonicalPath = this.getRepository().getWorkingDir().getCanonicalPath();
            Context.getLogger().debug("Calculating repository path...");
            Context.getLogger().debug("Path to checkout file: " + checkoutFileCanonicalPath);
            Context.getLogger().debug("Path to repository destination directory: " + destDirCanonicalPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getWorkingDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        relativePath = StringUtils.stripStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public List<String> readSourceByEdition(String path, String edition) {
        return new TfsCli(this.getRepository()).view(path, "C" + edition);
    }

    public List<String> readSourceByRevision(String path, TfsRevision revision) {
        return new TfsCli(this.getRepository()).view(path, "C" + (Object)((Object)revision));
    }

    public TfsRepository getRepository() {
        return (TfsRepository)super.getRepository();
    }
}

