/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.tfs.NodeAndDirBasedWorkspaceName;
import com.pmease.quickbuild.plugin.scm.tfs.TfsCli;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRevision;
import com.pmease.quickbuild.plugin.scm.tfs.TfsSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.tfs.WorkingFolder;
import com.pmease.quickbuild.plugin.scm.tfs.WorkspaceNameProvider;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SimpleTimeZone;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.util.EqualsHelper;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Team Foundation Server", description="Configure a Team Foundation Server repository here. By default, QuickBuild executes \"tf.exe\" to fetch changes from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Team Foundation Server plugin through the plugin management page.")
@ScriptApi
public class TfsRepository
extends AbstractRepository<TfsRevision> {
    private static final long serialVersionUID = 1L;
    private String serverUrl;
    private String username;
    private String password;
    private WorkspaceNameProvider workspaceNameProvider = new NodeAndDirBasedWorkspaceName(this);
    private String comment;
    private List<WorkingFolder> folders = new ArrayList<WorkingFolder>();
    private String buildRevision;
    private String destPath;
    public static final String URL = "url";
    public static final String PROJECT_PATH = "projectPath";
    public static final String WORKSPACE_NAME = "workspace";
    public static final String USERNAME = "username";
    public static final String WORKING_DIR = "workingDir";

    public Properties getCurrentRC() {
        Properties properties = new Properties();
        properties.put(URL, this.getServerUrl());
        return properties;
    }

    protected TfsCli getCli() {
        return new TfsCli(this);
    }

    protected void checkoutByRevision(TfsRevision revision) {
        this.getCli().createWorkspace().update(revision.toChangesetId());
    }

    public boolean exists() {
        File rcFile = this.getRCFile();
        return rcFile.exists();
    }

    protected List<Changeset> getChangesBetween(TfsRevision startRevision, TfsRevision endRevision) {
        Long start = Long.valueOf(startRevision.toString());
        Long end = Long.valueOf(endRevision.toString());
        if (start >= end) {
            this.getLogger().warn("Start revision '" + startRevision.toChangesetId() + "' is equal to or elder than end revision '" + endRevision.toChangesetId() + "'. Ignore calculating changes.");
            return Collections.emptyList();
        }
        List<Changeset> changes = this.getCli().changes(startRevision.toChangesetId() + "~" + endRevision.toChangesetId());
        Iterator<Changeset> it = changes.iterator();
        while (it.hasNext()) {
            Changeset change = it.next();
            if (!EqualsHelper.equals((Object)change.getId(), (Object)startRevision.toString())) continue;
            it.remove();
        }
        if (changes.isEmpty()) {
            this.getLogger().info("No changes found. All files are up to date.");
        }
        return changes;
    }

    protected TfsRevision getHeadRevision() {
        this.getLogger().info("Calculating revision for wokrspace [" + this.getWorkspaceName() + "] ...");
        String rev = StringUtils.isEmpty((String)this.getBuildRevision()) ? this.getCli().revision("T") : this.getCli().revision(this.getBuildRevision());
        if (StringUtils.isEmpty((String)rev)) {
            return null;
        }
        return new TfsRevision(rev);
    }

    public ProofBuildSupport<? extends LocalChange> getProofBuildSupport() {
        return null;
    }

    public SourceViewSupport<TfsRevision> getSourceViewSupport() {
        return new TfsSourceViewSupport(this);
    }

    protected boolean isQuietSince(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        StringBuffer sb = new StringBuffer();
        sb.append("D").append(dateFormat.format(date)).append("~").append("D").append(dateFormat.format(new Date()));
        List<Changeset> changes = this.getCli().changes(sb.toString(), 1);
        for (Changeset each : changes) {
            if (!each.getDate().after(date)) continue;
            return false;
        }
        return true;
    }

    protected void labelOnRevision(TfsRevision revision, String label, String comment) {
        this.getCli().label(revision.toChangesetId(), label, comment);
    }

    @Editable(order=1000, name="Server Url", description="Specifies url of a Team foundation server. If you are using TFS 2010, the url is team collection url, for example: <em>http://myserver:8080/tfs/DefaultCollection</em>. If you are using TFS 2005 or TFS 2008, you just need specify the server url like: http://myserver:8080/tfs")
    @NotEmpty
    @ScriptApi(value="Get URL of the repository to pull changes from.")
    @Scriptable
    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Editable(order=1100, name="User name", description="Optionally Specifies the user who has permission to access the above url. Either <em>username@domain</em> or domain\\username is valid.")
    @ScriptApi(value="Get the user name used to login the remote repository.")
    @Scriptable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Editable(order=1200, description="Specifies password of the above user.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(name="Workspace Name", order=1400, description="Specifies the workspace name here and QuickBuild will create the workspace automatically to check out code for the build.")
    @NotNull
    @ScriptApi(value="Get workspace name provider.")
    public WorkspaceNameProvider getWorkspaceNameProvider() {
        return this.workspaceNameProvider;
    }

    public void setWorkspaceNameProvider(WorkspaceNameProvider workspaceNameProvider) {
        this.workspaceNameProvider = workspaceNameProvider;
    }

    @ScriptApi(value="Get the specified workspace name.")
    public String getWorkspaceName() {
        return this.getWorkspaceNameProvider().getWorkspaceName();
    }

    @Editable(name="Workspace Comment", order=1900, description="Specifies the comment of workspace")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get the workspace comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Editable(order=1400, name="Destination Path", description="Specify the destination path to which contents in the above url will be retrieved into. This path is relative to the running configuration's workspace. If left empty, the workspace directory itself will be used to put checked out contents.")
    @ScriptApi(value="Get destination path to put checked out files. Null if workspace directory is used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(name="Working Folders", order=2100)
    @NotEmpty
    public List<WorkingFolder> getFolders() {
        return this.folders;
    }

    public void setFolders(List<WorkingFolder> folders) {
        this.folders = folders;
    }

    File getLocalFolder(String path) {
        return FileUtils.resolvePath((File)this.getWorkingDir(), (String)path);
    }

    public List<WorkingFolder> getEvaluatedFolders() {
        ArrayList<WorkingFolder> result = new ArrayList<WorkingFolder>();
        for (WorkingFolder each : this.getFolders()) {
            WorkingFolder folder = new WorkingFolder();
            folder.setServerPath(each.getServerPath());
            if (!each.isCloaked()) {
                folder.setLocalPath(this.getLocalFolder(each.getLocalPath()).getAbsolutePath());
            } else {
                folder.setLocalPath("");
            }
            folder.setStatus(each.getStatus());
            result.add(folder);
        }
        return result;
    }

    @Editable(order=2200, name="Version to Build", description="Optionally Specifies the version to build against. If not specified, the latest version will be used. When you specified version here, please follow the versionspec defined by Team Foundation Server, for example, versions below are accepted:<br/> Lmylable, or C1256, or T <br/>see <a href=\"http://msdn.microsoft.com/en-us/library/56f7w6be(v=VS.90).aspx\">here</a> for details.")
    @ScriptApi(value="Get specified version to build against. Null if build against latest version.")
    @Scriptable
    public String getBuildRevision() {
        return this.buildRevision;
    }

    public void setBuildRevision(String buildRevision) {
        this.buildRevision = buildRevision;
    }
}

