/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCommand;
import com.pmease.quickbuild.plugin.scm.helper.ScmHelperPlugin;
import com.pmease.quickbuild.plugin.scm.tfs.TfsPluginSetting;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRepository;
import org.apache.commons.lang.StringUtils;

public class TfsCommand
extends ScmCommand<TfsRepository> {
    public TfsCommand(TfsRepository repository) {
        super((AbstractRepository)repository);
    }

    public TfsCommand addServerArgument() {
        this.setValue(String.format("-server:%s", ((TfsRepository)this.repository).getServerUrl()));
        return this;
    }

    public TfsCommand addLoginArgument() {
        String username = ((TfsRepository)this.repository).getUsername();
        String password = ((TfsRepository)this.repository).getPassword();
        if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password)) {
            this.setValue(String.format("-login:%s,%s", username, password), String.format("-login:%s,*****", username));
        }
        return this;
    }

    public TfsCommand addWorkspaceArgument() {
        this.setValue("-workspace:" + ((TfsRepository)this.repository).getWorkspaceName());
        return this;
    }

    protected String getExePath() {
        if (ScmHelperPlugin.isTestMode()) {
            return "/Users/zhenyu/bin/tf";
        }
        String path = TfsPluginSetting.get().getTfExePath();
        if (StringUtils.isEmpty((String)path)) {
            return "tf";
        }
        return path;
    }
}

