/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Throwables;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCli;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractWorkspacesConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.RevisionConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.TEEChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.TEEWorkspacesConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.TfsCommand;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRepository;
import com.pmease.quickbuild.plugin.scm.tfs.WorkingFolder;
import com.pmease.quickbuild.plugin.scm.tfs.Workspace;
import com.pmease.quickbuild.plugin.scm.tfs.WorkspacesConsumer;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TfsCli
extends ScmCli<TfsCli, TfsRepository, TfsCommand> {
    public TfsCli(TfsRepository repository) {
        super((AbstractRepository)repository, null);
    }

    public List<Workspace> listWorkspaces() {
        AbstractWorkspacesConsumer consumer;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("List all workspaces in this machine");
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workspaces");
        command.addServerArgument();
        CLCType type = this.getCLCType();
        if (type == CLCType.TEE) {
            command.setValue("-format:xml");
            consumer = new TEEWorkspacesConsumer();
        } else {
            command.setValue("-format:detailed");
            consumer = new WorkspacesConsumer();
        }
        command.addLoginArgument();
        this.run(null, command, (LineConsumer)consumer);
        return consumer.getWorkspaces();
    }

    public Workspace findWorkspace(String workspaceName) {
        List<Workspace> workspaces = this.listWorkspaces();
        for (Workspace each : workspaces) {
            if (!each.getName().equalsIgnoreCase(workspaceName)) continue;
            return each;
        }
        return null;
    }

    private TfsCli createWorkspace(String workspaceName) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating workspace " + workspaceName);
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workspace");
        command.setValue("-new");
        command.setValue(workspaceName);
        command.setValue("-noprompt");
        command.setValue("-comment:Created by QuickBuild");
        command.addServerArgument();
        command.addLoginArgument();
        this.run(command, (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
        return this;
    }

    public TfsCli createWorkspace() {
        boolean needCreate;
        Workspace current = new Workspace((TfsRepository)this.repository);
        Workspace found = this.findWorkspace(((TfsRepository)this.repository).getWorkspaceName());
        boolean bl = needCreate = found == null;
        if (found != null && !current.equals(found)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Defined workspace: " + current + ", exist workspace: " + found);
            }
            this.deleteWorkspace(found.getName());
            needCreate = true;
        }
        if (needCreate) {
            FileUtils.cleanDir((File)this.getWorkingDir());
            this.createWorkspace(((TfsRepository)this.repository).getWorkspaceName());
            this.mapFolders();
        }
        return this;
    }

    boolean isFolderMapped(String serverPath) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Checking whether path '" + serverPath + "' is mapped or not ...");
        }
        TfsCommand cmd = (TfsCommand)this.buildCommand("workfold");
        cmd.setValue("-noprompt");
        cmd.addServerArgument();
        cmd.addLoginArgument();
        cmd.addWorkspaceArgument();
        cmd.setValue(serverPath);
        Commandline.ExecuteResult result = cmd.execute(null, null);
        return result.getReturnCode() == 0;
    }

    private void mapFolders() {
        QuickbuildException error = null;
        try {
            List<WorkingFolder> folders = ((TfsRepository)this.repository).getEvaluatedFolders();
            for (WorkingFolder each : folders) {
                if (each.isCloaked()) {
                    this.cloakFolder(each.getServerPath());
                    continue;
                }
                File localFolder = new File(each.getLocalPath());
                this.mapFolder(each.getServerPath(), localFolder.getAbsolutePath());
            }
        }
        catch (QuickbuildException e) {
            error = e;
            String workspace = ((TfsRepository)this.repository).getWorkspaceName();
            try {
                this.deleteWorkspace(workspace);
            }
            catch (ScmException e1) {
                this.getLogger().warn("Failed to delete the workspace " + workspace + " due to: ", (Throwable)e1);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public TfsCli deleteWorkspace(String workspaceName) {
        if (StringUtils.isEmpty((String)workspaceName)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The workspace is null, ignore deleting workspace");
            }
            return this;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Deleting workspace " + workspaceName + " ...");
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workspace");
        command.setValue("-delete");
        command.setValue("-noprompt");
        command.setValue(workspaceName);
        command.addServerArgument();
        command.addLoginArgument();
        this.run(null, command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
        return this;
    }

    public TfsCli mapFolder(String serverPath, String localPath) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Mapping server folder " + serverPath + " with local folder " + localPath);
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workfold");
        command.setValue("-map");
        command.setValue(serverPath);
        command.setValue(localPath);
        command.addServerArgument();
        command.addWorkspaceArgument();
        command.addLoginArgument();
        File localDir = new File(localPath);
        if (!localDir.exists()) {
            FileUtils.createDir((File)localDir);
        }
        return (TfsCli)this.run(localDir, command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public TfsCli cloakFolder(String serverPath) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Cloaking folder '" + serverPath + "' from workspace " + ((TfsRepository)this.repository).getWorkspaceName());
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workfold");
        command.setValue("-cloak");
        command.setValue(serverPath);
        command.addWorkspaceArgument();
        command.addServerArgument();
        command.addLoginArgument();
        return (TfsCli)this.run(null, command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public TfsCli unmapFolder(String workspace, String folder) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Unmapping folder '" + folder + "' from workspace " + workspace);
        }
        TfsCommand command = (TfsCommand)this.buildCommand("workfold");
        command.setValue("-unmap");
        command.addServerArgument();
        command.addWorkspaceArgument();
        command.setValue(folder);
        command.addLoginArgument();
        return (TfsCli)this.run(null, command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    private TfsCli update(File localFolder, String versionspec) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Checking out source content to workspace, command dir: '" + localFolder + "', version-spec: '" + versionspec + "' ...");
        }
        boolean forceUpdate = !((TfsRepository)this.repository).exists();
        TfsCommand command = (TfsCommand)this.buildCommand("get");
        command.setValue("-version:" + versionspec);
        command.setValue("-noprompt");
        if (forceUpdate) {
            command.setValue("-all");
        } else {
            command.setValue("-recursive");
        }
        command.addLoginArgument();
        if (!localFolder.exists()) {
            FileUtils.createDir((File)localFolder);
        }
        Commandline.ExecuteResult result = command.execute(localFolder, (OutputStream)new LineConsumer.DebugLogger(this.encoding), (LineConsumer)new LineConsumer.ErrorLogger(this.encoding));
        result.checkReturnCode();
        if (forceUpdate) {
            ((TfsRepository)this.repository).saveRC();
        }
        return this;
    }

    public TfsCli update(String versionspec) {
        List<WorkingFolder> folders = ((TfsRepository)this.repository).getEvaluatedFolders();
        File cmdFolder = null;
        for (WorkingFolder each : folders) {
            File localFolder = new File(each.getLocalPath());
            if (each.isCloaked()) continue;
            cmdFolder = localFolder;
            break;
        }
        if (cmdFolder == null) {
            throw new ScmException("No mapped directory found! Do you define your working folders correctly?");
        }
        return this.update(cmdFolder, versionspec);
    }

    public TfsCli checkin(String itemspec, String comment) {
        TfsCommand cmd = (TfsCommand)this.buildCommand("checkin");
        if (!StringUtils.isEmpty((String)comment)) {
            cmd.setValue("-comment:" + comment);
        }
        cmd.setValue("-noprompt");
        cmd.setValue("-recursive");
        cmd.setValue(itemspec);
        cmd.addLoginArgument();
        return (TfsCli)this.run(cmd, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public TfsCli checkout(String itemspec) {
        TfsCommand cmd = (TfsCommand)this.buildCommand("checkout");
        cmd.setValue("-recursive");
        cmd.setValue(itemspec);
        cmd.addLoginArgument();
        return (TfsCli)this.run(cmd, (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
    }

    private TfsCommand historyCommand(String itemspec, String format, String versionspec, int stopafter) {
        TfsCommand command = (TfsCommand)this.buildCommand("history");
        command.setValue(itemspec);
        command.setValue("-version:" + versionspec);
        command.setValue("-recursive");
        command.setValue("-noprompt");
        command.setValue("-format:" + format);
        if (stopafter > 0) {
            command.setValue("-stopafter:" + stopafter);
        }
        command.addServerArgument();
        command.addLoginArgument();
        return command;
    }

    private static void addProjectPath(String path, List<String> paths) {
        Iterator<String> it = paths.iterator();
        while (it.hasNext()) {
            String r;
            String shorter;
            String longer;
            String each = it.next();
            if (path.length() < each.length()) {
                longer = each;
                shorter = path;
            } else {
                longer = path;
                shorter = each;
            }
            if ((r = FileUtils.getRelativePath((String)longer, (String)shorter)) == null) continue;
            if (path.length() < each.length()) {
                it.remove();
                break;
            }
            return;
        }
        paths.add(path);
    }

    private List<String> getProjectPaths() {
        List<WorkingFolder> folders = ((TfsRepository)this.repository).getEvaluatedFolders();
        ArrayList<String> paths = new ArrayList<String>();
        for (WorkingFolder each : folders) {
            if (each.isCloaked()) continue;
            TfsCli.addProjectPath(each.getServerPath(), paths);
        }
        return paths;
    }

    public String revision(String versionspec) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Fetching revision info, version spec is: " + versionspec);
        }
        List<String> projectPaths = this.getProjectPaths();
        Long revision = null;
        for (String each : projectPaths) {
            TfsCommand command = this.historyCommand(each, "brief", versionspec, 1);
            RevisionConsumer consumer = new RevisionConsumer(null);
            this.run(null, command, (LineConsumer)consumer);
            Long num = consumer.getRevsion();
            if (num == null) continue;
            if (revision == null) {
                revision = num;
                continue;
            }
            revision = Math.max(revision, num);
        }
        if (revision == null) {
            throw new ScmException("Can not detect the revision (revision spec: '" + versionspec + "'.");
        }
        return revision.toString();
    }

    private List<Changeset> changes(String project, String versionspec, int stopafter) {
        AbstractChangeLogConsumer consumer;
        TfsCommand command;
        CLCType type;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Fetching changes with version-spec: " + versionspec);
        }
        if ((type = this.getCLCType()) == CLCType.TEE) {
            command = this.historyCommand(project, "xml", versionspec, stopafter);
            consumer = new TEEChangeLogConsumer(Log.LogLevel.DEBUG);
        } else {
            command = this.historyCommand(project, "detailed", versionspec, stopafter);
            consumer = new ChangeLogConsumer(Log.LogLevel.DEBUG);
        }
        this.run(null, command, (LineConsumer)consumer);
        return consumer.getChanges();
    }

    private static boolean isPathCloaked(String path, List<WorkingFolder> folders) {
        boolean cloaked = false;
        for (WorkingFolder each : folders) {
            String current = each.getServerPath();
            if (FileUtils.getRelativePath((String)path.toLowerCase(), (String)current.toLowerCase()) == null) continue;
            cloaked = each.isCloaked();
        }
        return cloaked;
    }

    private static Changeset removeCloakedModifications(Changeset change, List<WorkingFolder> folders) {
        List modifications = change.getModifications();
        Iterator it = modifications.iterator();
        while (it.hasNext()) {
            Modification each = (Modification)it.next();
            String path = each.getPath();
            if (!TfsCli.isPathCloaked(path, folders)) continue;
            it.remove();
        }
        if (modifications.isEmpty()) {
            return null;
        }
        return change;
    }

    public List<Changeset> changes(String versionspec) {
        return this.changes(versionspec, 0);
    }

    public List<Changeset> changes(String versionspec, int stopafter) {
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        List<WorkingFolder> folders = ((TfsRepository)this.repository).getEvaluatedFolders();
        boolean checkCloaked = false;
        for (WorkingFolder each : folders) {
            if (!each.isCloaked()) continue;
            checkCloaked = true;
            break;
        }
        List<String> projects = this.getProjectPaths();
        for (String each : projects) {
            List<Changeset> items = this.changes(each, versionspec, stopafter);
            for (Changeset change : items) {
                if (checkCloaked) {
                    Changeset actual = TfsCli.removeCloakedModifications(change, folders);
                    if (actual == null) continue;
                    changes.add(actual);
                    continue;
                }
                changes.add(change);
            }
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TfsCli label(String revision, String label, String comment) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Lable version " + revision + " as " + label);
        }
        List<WorkingFolder> folders = ((TfsRepository)this.repository).getEvaluatedFolders();
        for (WorkingFolder folder : folders) {
            if (folder.isCloaked()) continue;
            TfsCommand command = (TfsCommand)this.buildCommand("label");
            command.setValue(label);
            command.setValue(folder.getServerPath());
            command.setValue("-recursive");
            command.setValue("-child:replace");
            command.setValue("-version:" + revision);
            if (!StringUtils.isEmpty((String)comment)) {
                command.setValue("-comment:" + comment);
            }
            command.addServerArgument();
            command.addLoginArgument();
            File dir = new File(folder.getLocalPath());
            boolean needRemove = false;
            if (!dir.exists()) {
                Context.getLogger().debug("Folder " + dir + " doesn't exist, creating first ...");
                needRemove = true;
                FileUtils.createDir((File)dir);
            }
            try {
                this.run(new File(folder.getLocalPath()), command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
            }
            catch (QuickbuildException e) {
                if (Throwables.getStackTraceAsString((Throwable)e).contains("No matching items found")) continue;
                throw e;
            }
            finally {
                if (!needRemove) continue;
                Context.getLogger().debug("Removing folder " + dir + " ...");
                FileUtils.deleteDir((File)dir);
            }
        }
        return this;
    }

    public List<String> view(String path, String versionspec) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("View file " + path + " with version " + versionspec);
        }
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, null);
        CLCType type = this.getCLCType();
        TfsCommand command = type == CLCType.TEE ? (TfsCommand)this.buildCommand("print") : (TfsCommand)this.buildCommand("view");
        command.addServerArgument();
        if (type != CLCType.TEE) {
            command.setValue("-console");
        }
        command.setValue("-noprompt");
        command.setValue(path);
        command.setValue("-version:" + versionspec);
        command.addLoginArgument();
        this.run(null, command, (LineConsumer)consumer);
        return consumer.getLines();
    }

    public CLCType getCLCType() {
        TfsCommand command = (TfsCommand)this.buildCommand("help");
        LineListConsumer consumer = new LineListConsumer(null, null);
        this.run(null, command, (LineConsumer)consumer);
        String line = consumer.firstLine();
        if (line.contains("Team Explorer Everywhere")) {
            return CLCType.TEE;
        }
        return CLCType.VS;
    }

    public TfsCli sync() {
        throw new UnsupportedOperationException("Need not sync for Team Foundation Server repository");
    }

    protected void doSync() {
        throw new UnsupportedOperationException("Need not sync for Team Foundation Server repository");
    }

    protected TfsCommand createCommand() {
        return new TfsCommand((TfsRepository)this.repository);
    }

    public static enum CLCType {
        VS,
        TEE;

    }
}

