/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractWorkspacesConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.WorkingFolder;
import com.pmease.quickbuild.plugin.scm.tfs.Workspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TEEWorkspacesConsumer
extends AbstractWorkspacesConsumer {
    private final StringBuffer sb = new StringBuffer();
    boolean xmlStart = false;

    public TEEWorkspacesConsumer() {
        super(Log.LogLevel.DEBUG, null);
    }

    public void consume(String line) {
        if (this.xmlStart) {
            this.sb.append(line);
        } else if (line.trim().startsWith("<?xml") || line.trim().startsWith("<workspaces")) {
            this.xmlStart = true;
            this.sb.append(line);
        }
    }

    @Override
    public boolean hasWorkspace(Workspace expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Expected workspace should not be null");
        }
        String xml = this.sb.toString();
        this.logLine(xml);
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            for (Object each : root.elements("workspace")) {
                Workspace w = this.parseWorkspace((Element)each);
                if (!expected.equals(w)) continue;
                return true;
            }
            return false;
        }
        catch (DocumentException e) {
            this.logger.warn("Unable to parse the workspaces XML");
            return false;
        }
    }

    @Override
    public List<Workspace> getWorkspaces() {
        try {
            String xml = this.sb.toString();
            this.logLine(xml);
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
            for (Object each : root.elements("workspace")) {
                Workspace w = this.parseWorkspace((Element)each);
                workspaces.add(w);
            }
            return workspaces;
        }
        catch (DocumentException e) {
            this.logger.warn("Unable to parse the workspaces XML");
            return Collections.emptyList();
        }
    }

    private Workspace parseWorkspace(Element element) {
        Workspace workspace = new Workspace();
        workspace.setName(element.attributeValue("name"));
        workspace.setOwner(element.attributeValue("owner"));
        workspace.setServer(element.attributeValue("server"));
        for (Object each : element.elements("working-folder")) {
            Element welement = (Element)each;
            WorkingFolder wf = new WorkingFolder();
            wf.setServerPath(welement.attributeValue("server-item"));
            wf.setLocalPath(welement.attributeValue("local-item"));
            String type = welement.attributeValue("type");
            if ("cloak".equalsIgnoreCase(type)) {
                wf.setStatus(WorkingFolder.Status.Cloaked.name());
            } else {
                wf.setStatus(WorkingFolder.Status.Active.name());
            }
            workspace.addFolder(wf);
        }
        return workspace;
    }
}

