/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.ActionMul;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TEEChangeLogConsumer
extends AbstractChangeLogConsumer {
    boolean xmlStart = false;
    private final StringBuffer sb = new StringBuffer();
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public TEEChangeLogConsumer() {
        super(Log.LogLevel.DEBUG, null);
    }

    public TEEChangeLogConsumer(Log.LogLevel level) {
        super(level, null);
    }

    public void consume(String line) {
        this.logLine(line);
        if (line.trim().startsWith("<?xml") || line.trim().startsWith("<history")) {
            this.xmlStart = true;
        }
        this.sb.append(line).append("\n");
    }

    @Override
    public List<Changeset> getChanges() {
        String xml = this.sb.toString();
        if (StringUtils.isBlank((String)xml)) {
            return Collections.emptyList();
        }
        ArrayList changes = Lists.newArrayList();
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            for (Object each : doc.getRootElement().elements()) {
                Element element = (Element)each;
                String id = element.attributeValue("id");
                Long lId = Long.valueOf(id);
                String committer = element.attributeValue("committer");
                int pos = committer.indexOf(92);
                if (pos > 0) {
                    committer = committer.substring(pos + 1);
                }
                String d = element.attributeValue("date");
                Date date = DATE_FORMATTER.parseDateTime(d).toDate();
                String comment = element.valueOf("./comment");
                Changeset changeset = new Changeset();
                changes.add(changeset);
                changeset.setId(id);
                changeset.setComment(comment);
                changeset.setDate(date);
                changeset.setUser(committer);
                for (Object m : element.elements("item")) {
                    Element mElement = (Element)m;
                    Modification mod = new Modification();
                    mod.setEdition(id);
                    mod.setPreviousEdition(String.valueOf(lId - 1L));
                    mod.setPath(mElement.attributeValue("server-item"));
                    String changeType = mElement.attributeValue("change-type");
                    if (Strings.isNullOrEmpty((String)changeType)) {
                        mod.setAction(Modification.Action.MODIFY);
                    } else {
                        mod.setAction(ActionMul.getInstance().getAction(changeType));
                    }
                    changeset.getModifications().add(mod);
                }
            }
            return changes;
        }
        catch (DocumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void main(String[] args) {
        String d = "2013-06-17T22:48:58.70+0800";
        Date date = DATE_FORMATTER.parseDateTime(d).toDate();
        System.out.println(date);
    }
}

