/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.IdManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.plugin.scm.tfs.TfsRepository;
import com.pmease.quickbuild.plugin.scm.tfs.WorkspaceNameProvider;
import com.pmease.quickbuild.util.FileUtils;
import java.io.IOException;
import org.springframework.util.StringUtils;

@Editable(name="Auto-generated workspace name based on node and dest path", order=100)
public class NodeAndDirBasedWorkspaceName
implements WorkspaceNameProvider {
    private static final long serialVersionUID = 1L;
    private TfsRepository repository;
    private transient String workspaceName;

    public NodeAndDirBasedWorkspaceName(TfsRepository repository) {
        this.repository = repository;
    }

    @ScriptApi(value="Get associated repository object.")
    public TfsRepository getRepository() {
        return this.repository;
    }

    @Override
    @ScriptApi(value="Get the generated workspace name.")
    public String getWorkspaceName() {
        if (this.workspaceName == null) {
            GridNode node = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
            this.workspaceName = "qb-" + node.getHostName() + "-";
            try {
                String canonicalPath = this.repository.getWorkingDir().getCanonicalPath();
                String installPath = Bootstrap.installDir.getAbsolutePath();
                String relativePath = FileUtils.getRelativePath((String)canonicalPath, (String)installPath);
                IdManager idManager = (IdManager)Quickbuild.getInstance(IdManager.class);
                this.workspaceName = relativePath != null ? this.workspaceName + idManager.getId(String.valueOf(Bootstrap.getPort()) + ":" + relativePath) : this.workspaceName + idManager.getId(canonicalPath);
                this.workspaceName = StringUtils.replace((String)this.workspaceName, (String)" ", (String)"_");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.workspaceName;
    }
}

