/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.plugin.scm.tfs.AbstractChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.tfs.ActionMul;
import com.pmease.quickbuild.plugin.scm.tfs.DateUtils;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.LongValidator;

public class ChangeLogConsumer
extends AbstractChangeLogConsumer {
    protected static final String PATTERN_STR = "^[^:]*:[ \t]([0-9]*)\n[^:]*:[ \t](.*)\n[^:]*:[ \t](.*)\n[^:]*:((?:\n.*)*)\n\n[^\n :]*:(?=\n  )((?:\n[ \t]+.*)*)";
    private static final String PATTERN_ITEM_STR = "  ([^$]+) (\\$/.*)";
    private static final Pattern ITEM_PATTERN = Pattern.compile("  ([^$]+) (\\$/.*)");
    private static final String LOG_SEPARATOR = "-----";
    private List<Changeset> changes = new ArrayList<Changeset>();
    private List<String> block = new ArrayList<String>();
    private static final String ITEM_SEPARATOR = "  ";
    private static final Pattern CHANGESET_PATTERN = Pattern.compile("^[^:]*:[ \t]([0-9]*)", 64);

    public ChangeLogConsumer() {
        super(Log.LogLevel.TRACE, null);
    }

    public ChangeLogConsumer(Log.LogLevel level) {
        super(level, null);
    }

    public void consume(String line) {
        this.logLine(line);
        if (line.startsWith(LOG_SEPARATOR)) {
            Changeset change = this.parseChangeLog();
            if (change != null) {
                this.changes.add(change);
            }
            this.block = new ArrayList<String>();
        } else {
            this.block.add(line);
        }
    }

    private String getItemValue(String line) {
        int pos = line.indexOf(58);
        if (pos < 0) {
            return null;
        }
        return line.substring(pos + 1).trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Changeset parseChangeLog() {
        if (this.block.isEmpty()) {
            return null;
        }
        String line = this.block.get(0);
        Matcher m = CHANGESET_PATTERN.matcher(line);
        if (!m.find()) {
            return null;
        }
        Stage stage = Stage.Start;
        Changeset change = new Changeset();
        Long revision = 0L;
        StringBuffer commentBuffer = new StringBuffer();
        block13: for (String each : this.block) {
            boolean isItem = each.startsWith(ITEM_SEPARATOR);
            if (!isItem) {
                if (StringUtils.isBlank((String)each)) continue;
                stage = stage.next();
            }
            switch (stage) {
                case Start: {
                    throw new IllegalArgumentException();
                }
                case Changeset: {
                    String id = this.getItemValue(each);
                    try {
                        revision = LongValidator.getInstance().validate(id);
                        change.setId(revision.toString());
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new ScmException("Parse error. Unable to parse changeset line. Changeset [\n" + StringUtils.join(this.block, (String)"\n") + "\n].", (Throwable)e);
                    }
                }
                case User: {
                    change.setUser(this.getItemValue(each));
                    break;
                }
                case Date: {
                    try {
                        change.setDate(DateUtils.parseDate(this.getItemValue(each)));
                        break;
                    }
                    catch (ParseException e) {
                        throw new ScmException("Parse error. Unable to parse date line. Changeset [\n" + StringUtils.join(this.block, (String)"\n") + "\n].", (Throwable)e);
                    }
                }
                case Comment: {
                    if (!isItem) break;
                    if (each.length() > 2) {
                        commentBuffer.append(each.substring(2)).append("\n");
                        break;
                    }
                    commentBuffer.append(each).append("\n");
                    break;
                }
                case Items: {
                    Matcher itemMatcher;
                    if (!isItem || !(itemMatcher = ITEM_PATTERN.matcher(each)).find()) break;
                    Modification modification = new Modification();
                    String file = itemMatcher.group(2).trim();
                    if (!file.startsWith("$/")) {
                        throw new ScmException("Parse error. Mistakenly identified '" + file + "' as an item, but it does not appear to be a valid TFS path. Changeset [\n" + StringUtils.join(this.block, (String)"\n") + "\n].");
                    }
                    modification.setPath(itemMatcher.group(2).trim());
                    modification.setEdition(change.getId());
                    modification.setPreviousEdition(String.valueOf(revision - 1L));
                    String actionString = itemMatcher.group(1);
                    if (StringUtils.isEmpty((String)actionString)) {
                        throw new ScmException("Parse error. Can't identify the action for an item. Changeset [\n" + StringUtils.join(this.block, (String)"\n") + "\n].");
                    }
                    modification.setAction(ActionMul.getInstance().getAction(actionString));
                    change.getModifications().add(modification);
                    break;
                }
                case Notes: {
                    break block13;
                }
            }
        }
        change.setComment(commentBuffer.toString().trim());
        if (change.getModifications().isEmpty()) {
            this.getLogger().warn("No modification found in this changeset! This may caused by a failed parsing. Changeset [\n" + StringUtils.join(this.block, (String)"\n") + "\n].");
        }
        return change;
    }

    @Override
    public List<Changeset> getChanges() {
        Changeset change = this.parseChangeLog();
        if (change != null) {
            this.changes.add(change);
        }
        return this.changes;
    }

    private static enum Stage {
        Start,
        Changeset,
        User,
        Date,
        Comment,
        Items,
        Notes;


        public Stage next() {
            Stage[] values = Stage.values();
            return values[this.ordinal() + 1];
        }
    }
}

