/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.tfs;

import com.google.common.base.Splitter;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ActionMul {
    private static final ActionMul instance = new ActionMul();
    private Map<String, Set<String>> mapping = new HashMap<String, Set<String>>();

    public ActionMul() {
        try {
            this.load();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    private void load() throws UnsupportedEncodingException {
        InputStream in = ActionMul.class.getResourceAsStream("tfs-actions.mul");
        InputStreamReader r = new InputStreamReader(in, "UTF-8");
        BufferedReader reader = new BufferedReader(r);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int pos;
                if (StringUtils.isBlank((String)line) || (pos = line.indexOf(61)) <= 0) continue;
                String action = line.substring(0, pos).trim();
                String mul = line.substring(pos + 1).trim();
                HashSet<String> muls = new HashSet<String>();
                muls.add(action);
                Iterable iterable = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)mul);
                for (String each : iterable) {
                    if (StringUtils.isEmpty((String)each)) continue;
                    muls.add(each.trim());
                }
                this.mapping.put(action, muls);
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public Modification.Action getAction(String str) {
        String lower = str.toLowerCase();
        for (String each : this.mapping.keySet()) {
            Set<String> muls = this.mapping.get(each);
            for (String lang : muls) {
                if (!lower.startsWith(lang.toLowerCase())) continue;
                return Modification.Action.valueOf((String)each);
            }
        }
        throw new ScmException("Unknown action '" + str + "', you may need change your TFS to English version.");
    }

    public static ActionMul getInstance() {
        return instance;
    }
}

