module.exports = (grunt) ->
  grunt.loadNpmTasks 'grunt-contrib-coffee'
  grunt.loadNpmTasks 'grunt-simple-mocha'
  grunt.loadNpmTasks 'grunt-contrib-watch'
  grunt.initConfig
    coffee:
      dev: files: 'src/index.js': 'src/*.coffee'
      test: files: 'spec/electron_cookies_spec.js': 'spec/*.coffee'
    simplemocha: dev:
      src: 'spec/electron_cookies_spec.js'
      options:
        reporter: 'spec'
        slow: 200
        timeout: 1000
    watch: all:
      files: [
        'src/*.coffee'
        'spec/*.coffee'
      ]
      tasks: [
        'buildDev'
        'buildTest'
        'test'
      ]
  grunt.registerTask 'test', 'simplemocha:dev'
  grunt.registerTask 'buildDev', 'coffee:dev'
  grunt.registerTask 'buildTest', 'coffee:test'
  grunt.registerTask 'default', [
    'buildDev'
    'buildTest'
    'test'
    'watch:all'
  ]

# ---
# generated by js2coffee 2.0.4
