var app = require('app');
var Menu = require('menu');
var json = require('./package.json');

var template = [
  {
    label: json.name,
    submenu: [
      {
        label: '关于 ' + json.appname,
        selector: 'orderFrontStandardAboutPanel:'
      },
      {
        label: '检查更新',
        click: function () {
          app.emit('menu.checkUpdate')
        }
      },
      {
        type: 'separator'
      },
      {
        label: '服务',
        submenu: []
      },
      {
        type: 'separator'
      },
      {
        label: '隐藏 ' + json.appname,
        accelerator: 'Command+H',
        selector: 'hide:'
      },
      {
        label: '隐藏其它',
        accelerator: 'Command+Shift+H',
        selector: 'hideOtherApplications:'
      },
      {
        label: '显示所有',
        selector: 'unhideAllApplications:'
      },
      {
        type: 'separator'
      },
      {
        label: '退出',
        accelerator: 'Command+Q',
        click: function () {
          app.quit();
        }
      }

    ]
  },
  {
    label: '编辑',
    submenu: [
      {
        label: '撤销',
        accelerator: 'Command+Z',
        selector: 'undo:'
      },
      {
        label: '重做',
        accelerator: 'Shift+Command+Z',
        selector: 'redo:'
      },
      {
        type: 'separator'
      },
      {
        label: '剪切',
        accelerator: 'Command+X',
        selector: 'cut:'
      },
      {
        label: '复制',
        accelerator: 'Command+C',
        selector: 'copy:'
      },
      {
        label: '粘贴',
        accelerator: 'Command+V',
        selector: 'paste:'
      },
      {
        label: '选择全部',
        accelerator: 'Command+A',
        selector: 'selectAll:'
      }
    ]
  },
  {
    label: '视图',
    submenu: [
      {
        label: '重载',
        accelerator: 'Command+R',
        click: function () {
          app.emit('menu.reload')
        }
      }
    ]
  },
  {
    label: '窗口',
    submenu: [
      {
        label: '最小化',
        accelerator: 'Command+M',
        selector: 'performMiniaturize:'
      },
      {
        label: '关闭',
        accelerator: 'Command+W',
        selector: 'performClose:'
      },
      {
        type: 'separator'
      },
      {
        label: '前置所有窗口',
        selector: 'arrangeInFront:'
      }
    ]
  },
  {
    label: '应用',
    submenu: [
      {
        label: '截图',
        accelerator: 'Command+Ctrl+S',
        click: function () {
          app.emit('menu.screenshot')
        }
      }
    ]
  },
  {
    label: '帮助',
    submenu: [
      {
        label: '打开帮助',
        click: function () {
          app.emit('menu.help')
        }
      },
      {
        label: '访问网站',
        click: function () {
          app.emit('menu.homepage')
        }
      }
    ]
  }
];

var menu = Menu.buildFromTemplate(template);
Menu.setApplicationMenu(menu);
