'use strict';

// Support local cookies
require('electron-cookies');

var fetch = require('node-fetch')
  , json = require('./package.json')
  , appUrl = json.pubuim.appUrl
  , retry = document.querySelector('#retry')

function setLoadStatus(status) {
  var load = document.querySelector('#load');
  var loadFail = document.querySelector('#load-fail');

  switch (status) {
    case 0:
      load.className = '';
      loadFail.className = 'hide';
      break;
    case -1:
      load.className = 'hide';
      loadFail.className = '';
      break;
  }
}

function setVersion() {
  document.querySelector('#version').innerText = `${json.appname} ${json.version}`
}

function loadApp() {
  setVersion();
  setLoadStatus(0);
  fetch(appUrl + '?r=' + Math.random())
    .then(function () {
      setLoadStatus(1);
      window.location = appUrl;
    }, function () {
      setLoadStatus(-1);
    });
}

loadApp();

retry.onclick = function () {
  loadApp();
};
