/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class SliderBehavior
extends BehaviorBase<Slider> {
    protected static final List<KeyBinding> SLIDER_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String string) {
        if ("Home".equals(string)) {
            this.home();
        } else if ("End".equals(string)) {
            this.end();
        } else if ("IncrementValue".equals(string)) {
            this.incrementValue();
        } else if ("DecrementValue".equals(string)) {
            this.decrementValue();
        } else {
            super.callAction(string);
        }
    }

    public SliderBehavior(Slider slider) {
        super(slider);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return SLIDER_BINDINGS;
    }

    public void trackPress(MouseEvent mouseEvent, double d) {
        Slider slider = (Slider)this.getControl();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        if (slider.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            slider.adjustValue(d * (slider.getMax() - slider.getMin()) + slider.getMin());
        } else {
            slider.adjustValue((1.0 - d) * (slider.getMax() - slider.getMin()) + slider.getMin());
        }
    }

    public void trackRelease(MouseEvent mouseEvent, double d) {
    }

    public void thumbPressed(MouseEvent mouseEvent, double d) {
        Slider slider = (Slider)this.getControl();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setValueChanging(true);
    }

    public void thumbDragged(MouseEvent mouseEvent, double d) {
        Slider slider = (Slider)this.getControl();
        slider.setValue(Utils.clamp(slider.getMin(), d * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax()));
    }

    private double snapValueToTicks(double d) {
        Slider slider = (Slider)this.getControl();
        double d2 = d;
        double d3 = 0.0;
        d3 = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        int n = (int)((d2 - slider.getMin()) / d3);
        double d4 = (double)n * d3 + slider.getMin();
        double d5 = (double)(n + 1) * d3 + slider.getMin();
        d2 = Utils.nearest(d4, d2, d5);
        return Utils.clamp(slider.getMin(), d2, slider.getMax());
    }

    public void thumbReleased(MouseEvent mouseEvent) {
        Slider slider = (Slider)this.getControl();
        slider.setValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setValue(this.snapValueToTicks(slider.getValue()));
        }
    }

    void home() {
        Slider slider = (Slider)this.getControl();
        slider.adjustValue(slider.getMin());
    }

    void decrementValue() {
        Slider slider = (Slider)this.getControl();
        if (slider.isSnapToTicks()) {
            slider.adjustValue(slider.getValue() - this.computeIncrement());
        } else {
            slider.decrement();
        }
    }

    void end() {
        Slider slider = (Slider)this.getControl();
        slider.adjustValue(slider.getMax());
    }

    void incrementValue() {
        Slider slider = (Slider)this.getControl();
        if (slider.isSnapToTicks()) {
            slider.adjustValue(slider.getValue() + this.computeIncrement());
        } else {
            slider.increment();
        }
    }

    double computeIncrement() {
        Slider slider = (Slider)this.getControl();
        double d = 0.0;
        d = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        if (slider.getBlockIncrement() > 0.0 && slider.getBlockIncrement() < d) {
            return d;
        }
        return slider.getBlockIncrement();
    }

    static {
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.LEFT, "DecrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_LEFT, "DecrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.UP, "IncrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_UP, "IncrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.RIGHT, "IncrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_RIGHT, "IncrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.DOWN, "DecrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_DOWN, "DecrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.LEFT, "TraverseLeft").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_LEFT, "TraverseLeft").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.UP, "TraverseUp"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_UP, "TraverseUp"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.RIGHT, "TraverseRight").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_RIGHT, "TraverseRight").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.DOWN, "TraverseDown"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_DOWN, "TraverseDown"));
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_RELEASED, "Home"));
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_RELEASED, "End"));
    }

    public static class SliderKeyBinding
    extends OrientedKeyBinding {
        public SliderKeyBinding(KeyCode keyCode, String string) {
            super(keyCode, string);
        }

        public SliderKeyBinding(KeyCode keyCode, EventType<KeyEvent> eventType, String string) {
            super(keyCode, eventType, string);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((Slider)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

