/*
 * Decompiled with CFR 0.152.
 */
package dnl.logging;

import dnl.logging.Appender;
import dnl.logging.CallerData;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

class PrintStreamAppender
extends Appender {
    private static SimpleDateFormat sdf = new SimpleDateFormat("'['dd.MM.yyyy HH:mm:ss']'");
    private PrintStream outStream;
    private PrintStream errStream;

    public PrintStreamAppender() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public PrintStreamAppender(PrintStream printStream) {
        this.outStream = printStream;
        this.errStream = printStream;
    }

    public PrintStreamAppender(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
    }

    private void prefix(String level, CallerData caller, String s, PrintStream printStream) {
        printStream.print("--- ");
        printStream.print(level);
        printStream.println(" ----------------------------------------");
        if (this.showTime) {
            printStream.print(sdf.format(new Date()));
            printStream.print("  ");
            printStream.print(" - ");
        }
        printStream.print(this.getCallerString(caller));
        if (this.isShowLines()) {
            printStream.print(" line ");
            printStream.print(caller.getLine());
        }
        printStream.print(":  ");
        printStream.println(s);
    }

    @Override
    public void debug(CallerData caller, String s) {
        this.prefix("DEBUG", caller, s, this.outStream);
    }

    @Override
    public void info(CallerData caller, String s) {
        this.prefix("INFO", caller, s, this.outStream);
    }

    @Override
    public void warn(CallerData caller, String s) {
        this.prefix("WARN", caller, s, this.outStream);
    }

    @Override
    public void error(CallerData caller, String s) {
        this.prefix("ERROR", caller, s, this.errStream);
    }

    @Override
    public void fatal(CallerData caller, String s) {
        this.prefix("FATAL", caller, s, this.errStream);
    }
}

