/*
 * Decompiled with CFR 0.152.
 */
package dnl.logging;

import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class DecoratedLayout
extends Layout {
    protected boolean useSeparator = false;
    protected boolean useDecorators = false;
    protected boolean showTime = false;
    protected String logSeparator = "\n";
    protected String[] fatalDecorators = EMPTY_DECORATOR;
    protected String[] errorDecorators = EMPTY_DECORATOR;
    protected String[] warnDecorators = EMPTY_DECORATOR;
    protected String[] infoDecorators = EMPTY_DECORATOR;
    protected String[] debugDecorators = EMPTY_DECORATOR;
    private static final String[] EMPTY_DECORATOR = new String[]{"", ""};
    protected static DateFormat dateFormat = DateFormat.getDateInstance();
    protected static String MESSAGE_DELIMS = "\n";
    protected static String margin = DecoratedLayout.createMarginString();

    public String format(LoggingEvent logEvent) {
        StringBuffer sb = new StringBuffer();
        sb.append(dateFormat.format(new Date()));
        sb.append(" [");
        sb.append(logEvent.getThreadName());
        sb.append("]  ");
        String[] decorator = this.getDecoratorForLevel(logEvent.getLevel());
        sb.append(decorator[0]);
        sb.append(logEvent.getLevel());
        sb.append(decorator[1]);
        sb.append(" ");
        sb.append(logEvent.getLoggerName());
        sb.append(MESSAGE_DELIMS);
        Object messageObj = logEvent.getMessage();
        String message = messageObj == null ? "" : messageObj.toString();
        StringTokenizer tokenizer = new StringTokenizer(message, MESSAGE_DELIMS);
        while (tokenizer.hasMoreTokens()) {
            sb.append(margin);
            sb.append(tokenizer.nextToken());
            sb.append(MESSAGE_DELIMS);
        }
        if (this.useSeparator()) {
            sb.append(this.getLogSeparator());
        }
        return sb.toString();
    }

    public boolean useSeparator() {
        return this.useSeparator;
    }

    public void setUseSeparator(boolean useSeparator) {
        this.useSeparator = useSeparator;
    }

    public String getLogSeparator() {
        return this.logSeparator;
    }

    public void setLogSeparator(String logSeparator) {
        this.logSeparator = StringUtils.replace((String)logSeparator, (String)"\\n", (String)"\n");
        if (this.logSeparator.indexOf(10) == -1) {
            this.logSeparator = String.valueOf(this.logSeparator) + "\n";
        }
    }

    public void setDecorators(String decorators) {
        StringTokenizer st = new StringTokenizer(decorators, "|");
        while (st.hasMoreTokens()) {
            try {
                String tok = st.nextToken();
                int ind = tok.indexOf(58);
                String type = tok.substring(0, ind);
                String dec = tok.substring(ind + 1);
                int half = dec.length() / 2;
                String[] both = new String[]{dec.substring(0, half), dec.substring(half)};
                if ("debug".equalsIgnoreCase(type)) {
                    this.debugDecorators = both;
                }
                if ("info".equalsIgnoreCase(type)) {
                    this.infoDecorators = both;
                }
                if ("warn".equalsIgnoreCase(type)) {
                    this.warnDecorators = both;
                }
                if ("error".equalsIgnoreCase(type)) {
                    this.errorDecorators = both;
                }
                if (!"fatal".equalsIgnoreCase(type)) continue;
                this.fatalDecorators = both;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean ignoresThrowable() {
        return true;
    }

    public void activateOptions() {
    }

    private String[] getDecoratorForLevel(Level level) {
        switch (level.toInt()) {
            case 50000: {
                return this.fatalDecorators;
            }
            case 40000: {
                return this.errorDecorators;
            }
            case 30000: {
                return this.warnDecorators;
            }
            case 20000: {
                return this.infoDecorators;
            }
            case 10000: {
                return this.debugDecorators;
            }
        }
        return EMPTY_DECORATOR;
    }

    private static String createMarginString() {
        int length = dateFormat.format(new Date()).length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length + 1) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }
}

